/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"
#include <stdio.h>
#include "udm_unidata.h"

typedef struct {
	unsigned short ctype;
	unsigned short tolower;
} UDM_UNICODE;
 
typedef struct {
	int ctype;
	UDM_UNICODE * table;
} UDM_UNI_PLANE;


static UDM_UNICODE plane00[257]={
	{0,0x0000},	{0,0x0001},	{0,0x0002},	{0,0x0003},
	{0,0x0004},	{0,0x0005},	{0,0x0006},	{0,0x0007},
	{0,0x0008},	{0,0x0009},	{0,0x000A},	{0,0x000B},
	{0,0x000C},	{0,0x000D},	{0,0x000E},	{0,0x000F},
	{0,0x0010},	{0,0x0011},	{0,0x0012},	{0,0x0013},
	{0,0x0014},	{0,0x0015},	{0,0x0016},	{0,0x0017},
	{0,0x0018},	{0,0x0019},	{0,0x001A},	{0,0x001B},
	{0,0x001C},	{0,0x001D},	{0,0x001E},	{0,0x001F},
	{0,0x0020},	{0,0x0021},	{0,0x0022},	{0,0x0023},
	{0,0x0024},	{0,0x0025},	{0,0x0026},	{0,0x0027},
	{0,0x0028},	{0,0x0029},	{0,0x002A},	{0,0x002B},
	{0,0x002C},	{0,0x002D},	{0,0x002E},	{0,0x002F},
	{2,0x0030},	{2,0x0031},	{2,0x0032},	{2,0x0033},
	{2,0x0034},	{2,0x0035},	{2,0x0036},	{2,0x0037},
	{2,0x0038},	{2,0x0039},	{0,0x003A},	{0,0x003B},
	{0,0x003C},	{0,0x003D},	{0,0x003E},	{0,0x003F},
	{0,0x0040},	{1,0x0061},	{1,0x0062},	{1,0x0063},
	{1,0x0064},	{1,0x0065},	{1,0x0066},	{1,0x0067},
	{1,0x0068},	{1,0x0069},	{1,0x006A},	{1,0x006B},
	{1,0x006C},	{1,0x006D},	{1,0x006E},	{1,0x006F},
	{1,0x0070},	{1,0x0071},	{1,0x0072},	{1,0x0073},
	{1,0x0074},	{1,0x0075},	{1,0x0076},	{1,0x0077},
	{1,0x0078},	{1,0x0079},	{1,0x007A},	{0,0x005B},
	{0,0x005C},	{0,0x005D},	{0,0x005E},	{0,0x005F},
	{0,0x0060},	{1,0x0061},	{1,0x0062},	{1,0x0063},
	{1,0x0064},	{1,0x0065},	{1,0x0066},	{1,0x0067},
	{1,0x0068},	{1,0x0069},	{1,0x006A},	{1,0x006B},
	{1,0x006C},	{1,0x006D},	{1,0x006E},	{1,0x006F},
	{1,0x0070},	{1,0x0071},	{1,0x0072},	{1,0x0073},
	{1,0x0074},	{1,0x0075},	{1,0x0076},	{1,0x0077},
	{1,0x0078},	{1,0x0079},	{1,0x007A},	{0,0x007B},
	{0,0x007C},	{0,0x007D},	{0,0x007E},	{0,0x007F},
	{0,0x0080},	{0,0x0081},	{0,0x0082},	{0,0x0083},
	{0,0x0084},	{0,0x0085},	{0,0x0086},	{0,0x0087},
	{0,0x0088},	{0,0x0089},	{0,0x008A},	{0,0x008B},
	{0,0x008C},	{0,0x008D},	{0,0x008E},	{0,0x008F},
	{0,0x0090},	{0,0x0091},	{0,0x0092},	{0,0x0093},
	{0,0x0094},	{0,0x0095},	{0,0x0096},	{0,0x0097},
	{0,0x0098},	{0,0x0099},	{0,0x009A},	{0,0x009B},
	{0,0x009C},	{0,0x009D},	{0,0x009E},	{0,0x009F},
	{0,0x00A0},	{0,0x00A1},	{0,0x00A2},	{0,0x00A3},
	{0,0x00A4},	{0,0x00A5},	{0,0x00A6},	{0,0x00A7},
	{0,0x00A8},	{0,0x00A9},	{1,0x00AA},	{0,0x00AB},
	{0,0x00AC},	{0,0x00AD},	{0,0x00AE},	{0,0x00AF},
	{0,0x00B0},	{0,0x00B1},	{0,0x00B2},	{0,0x00B3},
	{0,0x00B4},	{1,0x00B5},	{0,0x00B6},	{0,0x00B7},
	{0,0x00B8},	{0,0x00B9},	{1,0x00BA},	{0,0x00BB},
	{0,0x00BC},	{0,0x00BD},	{0,0x00BE},	{0,0x00BF},
	{1,0x00E0},	{1,0x00E1},	{1,0x00E2},	{1,0x00E3},
	{1,0x00E4},	{1,0x00E5},	{1,0x00E6},	{1,0x00E7},
	{1,0x00E8},	{1,0x00E9},	{1,0x00EA},	{1,0x00EB},
	{1,0x00EC},	{1,0x00ED},	{1,0x00EE},	{1,0x00EF},
	{1,0x00F0},	{1,0x00F1},	{1,0x00F2},	{1,0x00F3},
	{1,0x00F4},	{1,0x00F5},	{1,0x00F6},	{0,0x00D7},
	{1,0x00F8},	{1,0x00F9},	{1,0x00FA},	{1,0x00FB},
	{1,0x00FC},	{1,0x00FD},	{1,0x00FE},	{1,0x00DF},
	{1,0x00E0},	{1,0x00E1},	{1,0x00E2},	{1,0x00E3},
	{1,0x00E4},	{1,0x00E5},	{1,0x00E6},	{1,0x00E7},
	{1,0x00E8},	{1,0x00E9},	{1,0x00EA},	{1,0x00EB},
	{1,0x00EC},	{1,0x00ED},	{1,0x00EE},	{1,0x00EF},
	{1,0x00F0},	{1,0x00F1},	{1,0x00F2},	{1,0x00F3},
	{1,0x00F4},	{1,0x00F5},	{1,0x00F6},	{0,0x00F7},
	{1,0x00F8},	{1,0x00F9},	{1,0x00FA},	{1,0x00FB},
	{1,0x00FC},	{1,0x00FD},	{1,0x00FE},	{1,0x00FF},
{0,0}};

static UDM_UNICODE plane01[257]={
	{1,0x0101},	{1,0x0101},	{1,0x0103},	{1,0x0103},
	{1,0x0105},	{1,0x0105},	{1,0x0107},	{1,0x0107},
	{1,0x0109},	{1,0x0109},	{1,0x010B},	{1,0x010B},
	{1,0x010D},	{1,0x010D},	{1,0x010F},	{1,0x010F},
	{1,0x0111},	{1,0x0111},	{1,0x0113},	{1,0x0113},
	{1,0x0115},	{1,0x0115},	{1,0x0117},	{1,0x0117},
	{1,0x0119},	{1,0x0119},	{1,0x011B},	{1,0x011B},
	{1,0x011D},	{1,0x011D},	{1,0x011F},	{1,0x011F},
	{1,0x0121},	{1,0x0121},	{1,0x0123},	{1,0x0123},
	{1,0x0125},	{1,0x0125},	{1,0x0127},	{1,0x0127},
	{1,0x0129},	{1,0x0129},	{1,0x012B},	{1,0x012B},
	{1,0x012D},	{1,0x012D},	{1,0x012F},	{1,0x012F},
	{1,0x0069},	{1,0x0131},	{1,0x0133},	{1,0x0133},
	{1,0x0135},	{1,0x0135},	{1,0x0137},	{1,0x0137},
	{1,0x0138},	{1,0x013A},	{1,0x013A},	{1,0x013C},
	{1,0x013C},	{1,0x013E},	{1,0x013E},	{1,0x0140},
	{1,0x0140},	{1,0x0142},	{1,0x0142},	{1,0x0144},
	{1,0x0144},	{1,0x0146},	{1,0x0146},	{1,0x0148},
	{1,0x0148},	{1,0x0149},	{1,0x014B},	{1,0x014B},
	{1,0x014D},	{1,0x014D},	{1,0x014F},	{1,0x014F},
	{1,0x0151},	{1,0x0151},	{1,0x0153},	{1,0x0153},
	{1,0x0155},	{1,0x0155},	{1,0x0157},	{1,0x0157},
	{1,0x0159},	{1,0x0159},	{1,0x015B},	{1,0x015B},
	{1,0x015D},	{1,0x015D},	{1,0x015F},	{1,0x015F},
	{1,0x0161},	{1,0x0161},	{1,0x0163},	{1,0x0163},
	{1,0x0165},	{1,0x0165},	{1,0x0167},	{1,0x0167},
	{1,0x0169},	{1,0x0169},	{1,0x016B},	{1,0x016B},
	{1,0x016D},	{1,0x016D},	{1,0x016F},	{1,0x016F},
	{1,0x0171},	{1,0x0171},	{1,0x0173},	{1,0x0173},
	{1,0x0175},	{1,0x0175},	{1,0x0177},	{1,0x0177},
	{1,0x00FF},	{1,0x017A},	{1,0x017A},	{1,0x017C},
	{1,0x017C},	{1,0x017E},	{1,0x017E},	{1,0x017F},
	{1,0x0180},	{1,0x0253},	{1,0x0183},	{1,0x0183},
	{1,0x0185},	{1,0x0185},	{1,0x0254},	{1,0x0188},
	{1,0x0188},	{1,0x0256},	{1,0x0257},	{1,0x018C},
	{1,0x018C},	{1,0x018D},	{1,0x01DD},	{1,0x0259},
	{1,0x025B},	{1,0x0192},	{1,0x0192},	{1,0x0260},
	{1,0x0263},	{1,0x0195},	{1,0x0269},	{1,0x0268},
	{1,0x0199},	{1,0x0199},	{1,0x019A},	{1,0x019B},
	{1,0x026F},	{1,0x0272},	{1,0x019E},	{1,0x0275},
	{1,0x01A1},	{1,0x01A1},	{1,0x01A3},	{1,0x01A3},
	{1,0x01A5},	{1,0x01A5},	{1,0x0280},	{1,0x01A8},
	{1,0x01A8},	{1,0x0283},	{1,0x01AA},	{1,0x01AB},
	{1,0x01AD},	{1,0x01AD},	{1,0x0288},	{1,0x01B0},
	{1,0x01B0},	{1,0x028A},	{1,0x028B},	{1,0x01B4},
	{1,0x01B4},	{1,0x01B6},	{1,0x01B6},	{1,0x0292},
	{1,0x01B9},	{1,0x01B9},	{1,0x01BA},	{1,0x01BB},
	{1,0x01BD},	{1,0x01BD},	{1,0x01BE},	{1,0x01BF},
	{1,0x01C0},	{1,0x01C1},	{1,0x01C2},	{1,0x01C3},
	{1,0x01C6},	{0,0x01C6},	{1,0x01C6},	{1,0x01C9},
	{0,0x01C9},	{1,0x01C9},	{1,0x01CC},	{0,0x01CC},
	{1,0x01CC},	{1,0x01CE},	{1,0x01CE},	{1,0x01D0},
	{1,0x01D0},	{1,0x01D2},	{1,0x01D2},	{1,0x01D4},
	{1,0x01D4},	{1,0x01D6},	{1,0x01D6},	{1,0x01D8},
	{1,0x01D8},	{1,0x01DA},	{1,0x01DA},	{1,0x01DC},
	{1,0x01DC},	{1,0x01DD},	{1,0x01DF},	{1,0x01DF},
	{1,0x01E1},	{1,0x01E1},	{1,0x01E3},	{1,0x01E3},
	{1,0x01E5},	{1,0x01E5},	{1,0x01E7},	{1,0x01E7},
	{1,0x01E9},	{1,0x01E9},	{1,0x01EB},	{1,0x01EB},
	{1,0x01ED},	{1,0x01ED},	{1,0x01EF},	{1,0x01EF},
	{1,0x01F0},	{1,0x01F3},	{0,0x01F3},	{1,0x01F3},
	{1,0x01F5},	{1,0x01F5},	{1,0x0195},	{1,0x01BF},
	{1,0x01F9},	{1,0x01F9},	{1,0x01FB},	{1,0x01FB},
	{1,0x01FD},	{1,0x01FD},	{1,0x01FF},	{1,0x01FF},
{0,0}};

static UDM_UNICODE plane02[257]={
	{1,0x0201},	{1,0x0201},	{1,0x0203},	{1,0x0203},
	{1,0x0205},	{1,0x0205},	{1,0x0207},	{1,0x0207},
	{1,0x0209},	{1,0x0209},	{1,0x020B},	{1,0x020B},
	{1,0x020D},	{1,0x020D},	{1,0x020F},	{1,0x020F},
	{1,0x0211},	{1,0x0211},	{1,0x0213},	{1,0x0213},
	{1,0x0215},	{1,0x0215},	{1,0x0217},	{1,0x0217},
	{1,0x0219},	{1,0x0219},	{1,0x021B},	{1,0x021B},
	{1,0x021D},	{1,0x021D},	{1,0x021F},	{1,0x021F},
	{0,0x0220},	{0,0x0221},	{1,0x0223},	{1,0x0223},
	{1,0x0225},	{1,0x0225},	{1,0x0227},	{1,0x0227},
	{1,0x0229},	{1,0x0229},	{1,0x022B},	{1,0x022B},
	{1,0x022D},	{1,0x022D},	{1,0x022F},	{1,0x022F},
	{1,0x0231},	{1,0x0231},	{1,0x0233},	{1,0x0233},
	{0,0x0234},	{0,0x0235},	{0,0x0236},	{0,0x0237},
	{0,0x0238},	{0,0x0239},	{0,0x023A},	{0,0x023B},
	{0,0x023C},	{0,0x023D},	{0,0x023E},	{0,0x023F},
	{0,0x0240},	{0,0x0241},	{0,0x0242},	{0,0x0243},
	{0,0x0244},	{0,0x0245},	{0,0x0246},	{0,0x0247},
	{0,0x0248},	{0,0x0249},	{0,0x024A},	{0,0x024B},
	{0,0x024C},	{0,0x024D},	{0,0x024E},	{0,0x024F},
	{1,0x0250},	{1,0x0251},	{1,0x0252},	{1,0x0253},
	{1,0x0254},	{1,0x0255},	{1,0x0256},	{1,0x0257},
	{1,0x0258},	{1,0x0259},	{1,0x025A},	{1,0x025B},
	{1,0x025C},	{1,0x025D},	{1,0x025E},	{1,0x025F},
	{1,0x0260},	{1,0x0261},	{1,0x0262},	{1,0x0263},
	{1,0x0264},	{1,0x0265},	{1,0x0266},	{1,0x0267},
	{1,0x0268},	{1,0x0269},	{1,0x026A},	{1,0x026B},
	{1,0x026C},	{1,0x026D},	{1,0x026E},	{1,0x026F},
	{1,0x0270},	{1,0x0271},	{1,0x0272},	{1,0x0273},
	{1,0x0274},	{1,0x0275},	{1,0x0276},	{1,0x0277},
	{1,0x0278},	{1,0x0279},	{1,0x027A},	{1,0x027B},
	{1,0x027C},	{1,0x027D},	{1,0x027E},	{1,0x027F},
	{1,0x0280},	{1,0x0281},	{1,0x0282},	{1,0x0283},
	{1,0x0284},	{1,0x0285},	{1,0x0286},	{1,0x0287},
	{1,0x0288},	{1,0x0289},	{1,0x028A},	{1,0x028B},
	{1,0x028C},	{1,0x028D},	{1,0x028E},	{1,0x028F},
	{1,0x0290},	{1,0x0291},	{1,0x0292},	{1,0x0293},
	{1,0x0294},	{1,0x0295},	{1,0x0296},	{1,0x0297},
	{1,0x0298},	{1,0x0299},	{1,0x029A},	{1,0x029B},
	{1,0x029C},	{1,0x029D},	{1,0x029E},	{1,0x029F},
	{1,0x02A0},	{1,0x02A1},	{1,0x02A2},	{1,0x02A3},
	{1,0x02A4},	{1,0x02A5},	{1,0x02A6},	{1,0x02A7},
	{1,0x02A8},	{1,0x02A9},	{1,0x02AA},	{1,0x02AB},
	{1,0x02AC},	{1,0x02AD},	{0,0x02AE},	{0,0x02AF},
	{1,0x02B0},	{1,0x02B1},	{1,0x02B2},	{1,0x02B3},
	{1,0x02B4},	{1,0x02B5},	{1,0x02B6},	{1,0x02B7},
	{1,0x02B8},	{0,0x02B9},	{0,0x02BA},	{1,0x02BB},
	{1,0x02BC},	{1,0x02BD},	{1,0x02BE},	{1,0x02BF},
	{1,0x02C0},	{1,0x02C1},	{0,0x02C2},	{0,0x02C3},
	{0,0x02C4},	{0,0x02C5},	{0,0x02C6},	{0,0x02C7},
	{0,0x02C8},	{0,0x02C9},	{0,0x02CA},	{0,0x02CB},
	{0,0x02CC},	{0,0x02CD},	{0,0x02CE},	{0,0x02CF},
	{1,0x02D0},	{1,0x02D1},	{0,0x02D2},	{0,0x02D3},
	{0,0x02D4},	{0,0x02D5},	{0,0x02D6},	{0,0x02D7},
	{0,0x02D8},	{0,0x02D9},	{0,0x02DA},	{0,0x02DB},
	{0,0x02DC},	{0,0x02DD},	{0,0x02DE},	{0,0x02DF},
	{1,0x02E0},	{1,0x02E1},	{1,0x02E2},	{1,0x02E3},
	{1,0x02E4},	{0,0x02E5},	{0,0x02E6},	{0,0x02E7},
	{0,0x02E8},	{0,0x02E9},	{0,0x02EA},	{0,0x02EB},
	{0,0x02EC},	{0,0x02ED},	{1,0x02EE},	{0,0x02EF},
	{0,0x02F0},	{0,0x02F1},	{0,0x02F2},	{0,0x02F3},
	{0,0x02F4},	{0,0x02F5},	{0,0x02F6},	{0,0x02F7},
	{0,0x02F8},	{0,0x02F9},	{0,0x02FA},	{0,0x02FB},
	{0,0x02FC},	{0,0x02FD},	{0,0x02FE},	{0,0x02FF},
{0,0}};

static UDM_UNICODE plane03[257]={
	{1,0x0300},	{1,0x0301},	{1,0x0302},	{1,0x0303},
	{1,0x0304},	{1,0x0305},	{1,0x0306},	{1,0x0307},
	{1,0x0308},	{1,0x0309},	{1,0x030A},	{1,0x030B},
	{1,0x030C},	{1,0x030D},	{1,0x030E},	{1,0x030F},
	{1,0x0310},	{1,0x0311},	{1,0x0312},	{1,0x0313},
	{1,0x0314},	{1,0x0315},	{1,0x0316},	{1,0x0317},
	{1,0x0318},	{1,0x0319},	{1,0x031A},	{1,0x031B},
	{1,0x031C},	{1,0x031D},	{1,0x031E},	{1,0x031F},
	{1,0x0320},	{1,0x0321},	{1,0x0322},	{1,0x0323},
	{1,0x0324},	{1,0x0325},	{1,0x0326},	{1,0x0327},
	{1,0x0328},	{1,0x0329},	{1,0x032A},	{1,0x032B},
	{1,0x032C},	{1,0x032D},	{1,0x032E},	{1,0x032F},
	{1,0x0330},	{1,0x0331},	{1,0x0332},	{1,0x0333},
	{1,0x0334},	{1,0x0335},	{1,0x0336},	{1,0x0337},
	{1,0x0338},	{1,0x0339},	{1,0x033A},	{1,0x033B},
	{1,0x033C},	{1,0x033D},	{1,0x033E},	{1,0x033F},
	{1,0x0340},	{1,0x0341},	{1,0x0342},	{1,0x0343},
	{1,0x0344},	{1,0x0345},	{1,0x0346},	{1,0x0347},
	{1,0x0348},	{1,0x0349},	{1,0x034A},	{1,0x034B},
	{1,0x034C},	{1,0x034D},	{1,0x034E},	{0,0x034F},
	{0,0x0350},	{0,0x0351},	{0,0x0352},	{0,0x0353},
	{0,0x0354},	{0,0x0355},	{0,0x0356},	{0,0x0357},
	{0,0x0358},	{0,0x0359},	{0,0x035A},	{0,0x035B},
	{0,0x035C},	{0,0x035D},	{0,0x035E},	{0,0x035F},
	{1,0x0360},	{1,0x0361},	{1,0x0362},	{0,0x0363},
	{0,0x0364},	{0,0x0365},	{0,0x0366},	{0,0x0367},
	{0,0x0368},	{0,0x0369},	{0,0x036A},	{0,0x036B},
	{0,0x036C},	{0,0x036D},	{0,0x036E},	{0,0x036F},
	{0,0x0370},	{0,0x0371},	{0,0x0372},	{0,0x0373},
	{0,0x0374},	{0,0x0375},	{0,0x0376},	{0,0x0377},
	{0,0x0378},	{0,0x0379},	{1,0x037A},	{0,0x037B},
	{0,0x037C},	{0,0x037D},	{0,0x037E},	{0,0x037F},
	{0,0x0380},	{0,0x0381},	{0,0x0382},	{0,0x0383},
	{0,0x0384},	{0,0x0385},	{1,0x03AC},	{0,0x0387},
	{1,0x03AD},	{1,0x03AE},	{1,0x03AF},	{0,0x038B},
	{1,0x03CC},	{0,0x038D},	{1,0x03CD},	{1,0x03CE},
	{1,0x0390},	{1,0x03B1},	{1,0x03B2},	{1,0x03B3},
	{1,0x03B4},	{1,0x03B5},	{1,0x03B6},	{1,0x03B7},
	{1,0x03B8},	{1,0x03B9},	{1,0x03BA},	{1,0x03BB},
	{1,0x03BC},	{1,0x03BD},	{1,0x03BE},	{1,0x03BF},
	{1,0x03C0},	{1,0x03C1},	{0,0x03A2},	{1,0x03C3},
	{1,0x03C4},	{1,0x03C5},	{1,0x03C6},	{1,0x03C7},
	{1,0x03C8},	{1,0x03C9},	{1,0x03CA},	{1,0x03CB},
	{1,0x03AC},	{1,0x03AD},	{1,0x03AE},	{1,0x03AF},
	{1,0x03B0},	{1,0x03B1},	{1,0x03B2},	{1,0x03B3},
	{1,0x03B4},	{1,0x03B5},	{1,0x03B6},	{1,0x03B7},
	{1,0x03B8},	{1,0x03B9},	{1,0x03BA},	{1,0x03BB},
	{1,0x03BC},	{1,0x03BD},	{1,0x03BE},	{1,0x03BF},
	{1,0x03C0},	{1,0x03C1},	{1,0x03C2},	{1,0x03C3},
	{1,0x03C4},	{1,0x03C5},	{1,0x03C6},	{1,0x03C7},
	{1,0x03C8},	{1,0x03C9},	{1,0x03CA},	{1,0x03CB},
	{1,0x03CC},	{1,0x03CD},	{1,0x03CE},	{0,0x03CF},
	{1,0x03D0},	{1,0x03D1},	{1,0x03D2},	{1,0x03D3},
	{1,0x03D4},	{1,0x03D5},	{1,0x03D6},	{1,0x03D7},
	{0,0x03D8},	{0,0x03D9},	{1,0x03DB},	{1,0x03DB},
	{1,0x03DD},	{1,0x03DD},	{1,0x03DF},	{1,0x03DF},
	{1,0x03E1},	{1,0x03E1},	{1,0x03E3},	{1,0x03E3},
	{1,0x03E5},	{1,0x03E5},	{1,0x03E7},	{1,0x03E7},
	{1,0x03E9},	{1,0x03E9},	{1,0x03EB},	{1,0x03EB},
	{1,0x03ED},	{1,0x03ED},	{1,0x03EF},	{1,0x03EF},
	{1,0x03F0},	{1,0x03F1},	{1,0x03F2},	{1,0x03F3},
	{0,0x03F4},	{0,0x03F5},	{0,0x03F6},	{0,0x03F7},
	{0,0x03F8},	{0,0x03F9},	{0,0x03FA},	{0,0x03FB},
	{0,0x03FC},	{0,0x03FD},	{0,0x03FE},	{0,0x03FF},
{0,0}};

static UDM_UNICODE plane04[257]={
	{1,0x0450},	{1,0x0451},	{1,0x0452},	{1,0x0453},
	{1,0x0454},	{1,0x0455},	{1,0x0456},	{1,0x0457},
	{1,0x0458},	{1,0x0459},	{1,0x045A},	{1,0x045B},
	{1,0x045C},	{1,0x045D},	{1,0x045E},	{1,0x045F},
	{1,0x0430},	{1,0x0431},	{1,0x0432},	{1,0x0433},
	{1,0x0434},	{1,0x0435},	{1,0x0436},	{1,0x0437},
	{1,0x0438},	{1,0x0439},	{1,0x043A},	{1,0x043B},
	{1,0x043C},	{1,0x043D},	{1,0x043E},	{1,0x043F},
	{1,0x0440},	{1,0x0441},	{1,0x0442},	{1,0x0443},
	{1,0x0444},	{1,0x0445},	{1,0x0446},	{1,0x0447},
	{1,0x0448},	{1,0x0449},	{1,0x044A},	{1,0x044B},
	{1,0x044C},	{1,0x044D},	{1,0x044E},	{1,0x044F},
	{1,0x0430},	{1,0x0431},	{1,0x0432},	{1,0x0433},
	{1,0x0434},	{1,0x0435},	{1,0x0436},	{1,0x0437},
	{1,0x0438},	{1,0x0439},	{1,0x043A},	{1,0x043B},
	{1,0x043C},	{1,0x043D},	{1,0x043E},	{1,0x043F},
	{1,0x0440},	{1,0x0441},	{1,0x0442},	{1,0x0443},
	{1,0x0444},	{1,0x0445},	{1,0x0446},	{1,0x0447},
	{1,0x0448},	{1,0x0449},	{1,0x044A},	{1,0x044B},
	{1,0x044C},	{1,0x044D},	{1,0x044E},	{1,0x044F},
	{1,0x0450},	{1,0x0451},	{1,0x0452},	{1,0x0453},
	{1,0x0454},	{1,0x0455},	{1,0x0456},	{1,0x0457},
	{1,0x0458},	{1,0x0459},	{1,0x045A},	{1,0x045B},
	{1,0x045C},	{1,0x045D},	{1,0x045E},	{1,0x045F},
	{1,0x0461},	{1,0x0461},	{1,0x0463},	{1,0x0463},
	{1,0x0465},	{1,0x0465},	{1,0x0467},	{1,0x0467},
	{1,0x0469},	{1,0x0469},	{1,0x046B},	{1,0x046B},
	{1,0x046D},	{1,0x046D},	{1,0x046F},	{1,0x046F},
	{1,0x0471},	{1,0x0471},	{1,0x0473},	{1,0x0473},
	{1,0x0475},	{1,0x0475},	{1,0x0477},	{1,0x0477},
	{1,0x0479},	{1,0x0479},	{1,0x047B},	{1,0x047B},
	{1,0x047D},	{1,0x047D},	{1,0x047F},	{1,0x047F},
	{1,0x0481},	{1,0x0481},	{0,0x0482},	{1,0x0483},
	{1,0x0484},	{1,0x0485},	{1,0x0486},	{0,0x0487},
	{0,0x0488},	{0,0x0489},	{0,0x048A},	{0,0x048B},
	{1,0x048D},	{1,0x048D},	{1,0x048F},	{1,0x048F},
	{1,0x0491},	{1,0x0491},	{1,0x0493},	{1,0x0493},
	{1,0x0495},	{1,0x0495},	{1,0x0497},	{1,0x0497},
	{1,0x0499},	{1,0x0499},	{1,0x049B},	{1,0x049B},
	{1,0x049D},	{1,0x049D},	{1,0x049F},	{1,0x049F},
	{1,0x04A1},	{1,0x04A1},	{1,0x04A3},	{1,0x04A3},
	{1,0x04A5},	{1,0x04A5},	{1,0x04A7},	{1,0x04A7},
	{1,0x04A9},	{1,0x04A9},	{1,0x04AB},	{1,0x04AB},
	{1,0x04AD},	{1,0x04AD},	{1,0x04AF},	{1,0x04AF},
	{1,0x04B1},	{1,0x04B1},	{1,0x04B3},	{1,0x04B3},
	{1,0x04B5},	{1,0x04B5},	{1,0x04B7},	{1,0x04B7},
	{1,0x04B9},	{1,0x04B9},	{1,0x04BB},	{1,0x04BB},
	{1,0x04BD},	{1,0x04BD},	{1,0x04BF},	{1,0x04BF},
	{1,0x04C0},	{1,0x04C2},	{1,0x04C2},	{1,0x04C4},
	{1,0x04C4},	{0,0x04C5},	{0,0x04C6},	{1,0x04C8},
	{1,0x04C8},	{0,0x04C9},	{0,0x04CA},	{1,0x04CC},
	{1,0x04CC},	{0,0x04CD},	{0,0x04CE},	{0,0x04CF},
	{1,0x04D1},	{1,0x04D1},	{1,0x04D3},	{1,0x04D3},
	{1,0x04D5},	{1,0x04D5},	{1,0x04D7},	{1,0x04D7},
	{1,0x04D9},	{1,0x04D9},	{1,0x04DB},	{1,0x04DB},
	{1,0x04DD},	{1,0x04DD},	{1,0x04DF},	{1,0x04DF},
	{1,0x04E1},	{1,0x04E1},	{1,0x04E3},	{1,0x04E3},
	{1,0x04E5},	{1,0x04E5},	{1,0x04E7},	{1,0x04E7},
	{1,0x04E9},	{1,0x04E9},	{1,0x04EB},	{1,0x04EB},
	{1,0x04ED},	{1,0x04ED},	{1,0x04EF},	{1,0x04EF},
	{1,0x04F1},	{1,0x04F1},	{1,0x04F3},	{1,0x04F3},
	{1,0x04F5},	{1,0x04F5},	{0,0x04F6},	{0,0x04F7},
	{1,0x04F9},	{1,0x04F9},	{0,0x04FA},	{0,0x04FB},
	{0,0x04FC},	{0,0x04FD},	{0,0x04FE},	{0,0x04FF},
{0,0}};

static UDM_UNICODE plane05[257]={
	{0,0x0500},	{0,0x0501},	{0,0x0502},	{0,0x0503},
	{0,0x0504},	{0,0x0505},	{0,0x0506},	{0,0x0507},
	{0,0x0508},	{0,0x0509},	{0,0x050A},	{0,0x050B},
	{0,0x050C},	{0,0x050D},	{0,0x050E},	{0,0x050F},
	{0,0x0510},	{0,0x0511},	{0,0x0512},	{0,0x0513},
	{0,0x0514},	{0,0x0515},	{0,0x0516},	{0,0x0517},
	{0,0x0518},	{0,0x0519},	{0,0x051A},	{0,0x051B},
	{0,0x051C},	{0,0x051D},	{0,0x051E},	{0,0x051F},
	{0,0x0520},	{0,0x0521},	{0,0x0522},	{0,0x0523},
	{0,0x0524},	{0,0x0525},	{0,0x0526},	{0,0x0527},
	{0,0x0528},	{0,0x0529},	{0,0x052A},	{0,0x052B},
	{0,0x052C},	{0,0x052D},	{0,0x052E},	{0,0x052F},
	{0,0x0530},	{1,0x0561},	{1,0x0562},	{1,0x0563},
	{1,0x0564},	{1,0x0565},	{1,0x0566},	{1,0x0567},
	{1,0x0568},	{1,0x0569},	{1,0x056A},	{1,0x056B},
	{1,0x056C},	{1,0x056D},	{1,0x056E},	{1,0x056F},
	{1,0x0570},	{1,0x0571},	{1,0x0572},	{1,0x0573},
	{1,0x0574},	{1,0x0575},	{1,0x0576},	{1,0x0577},
	{1,0x0578},	{1,0x0579},	{1,0x057A},	{1,0x057B},
	{1,0x057C},	{1,0x057D},	{1,0x057E},	{1,0x057F},
	{1,0x0580},	{1,0x0581},	{1,0x0582},	{1,0x0583},
	{1,0x0584},	{1,0x0585},	{1,0x0586},	{0,0x0557},
	{0,0x0558},	{1,0x0559},	{0,0x055A},	{0,0x055B},
	{0,0x055C},	{0,0x055D},	{0,0x055E},	{0,0x055F},
	{0,0x0560},	{1,0x0561},	{1,0x0562},	{1,0x0563},
	{1,0x0564},	{1,0x0565},	{1,0x0566},	{1,0x0567},
	{1,0x0568},	{1,0x0569},	{1,0x056A},	{1,0x056B},
	{1,0x056C},	{1,0x056D},	{1,0x056E},	{1,0x056F},
	{1,0x0570},	{1,0x0571},	{1,0x0572},	{1,0x0573},
	{1,0x0574},	{1,0x0575},	{1,0x0576},	{1,0x0577},
	{1,0x0578},	{1,0x0579},	{1,0x057A},	{1,0x057B},
	{1,0x057C},	{1,0x057D},	{1,0x057E},	{1,0x057F},
	{1,0x0580},	{1,0x0581},	{1,0x0582},	{1,0x0583},
	{1,0x0584},	{1,0x0585},	{1,0x0586},	{1,0x0587},
	{0,0x0588},	{0,0x0589},	{0,0x058A},	{0,0x058B},
	{0,0x058C},	{0,0x058D},	{0,0x058E},	{0,0x058F},
	{0,0x0590},	{1,0x0591},	{1,0x0592},	{1,0x0593},
	{1,0x0594},	{1,0x0595},	{1,0x0596},	{1,0x0597},
	{1,0x0598},	{1,0x0599},	{1,0x059A},	{1,0x059B},
	{1,0x059C},	{1,0x059D},	{1,0x059E},	{1,0x059F},
	{1,0x05A0},	{1,0x05A1},	{0,0x05A2},	{1,0x05A3},
	{1,0x05A4},	{1,0x05A5},	{1,0x05A6},	{1,0x05A7},
	{1,0x05A8},	{1,0x05A9},	{1,0x05AA},	{1,0x05AB},
	{1,0x05AC},	{1,0x05AD},	{1,0x05AE},	{1,0x05AF},
	{1,0x05B0},	{1,0x05B1},	{1,0x05B2},	{1,0x05B3},
	{1,0x05B4},	{1,0x05B5},	{1,0x05B6},	{1,0x05B7},
	{1,0x05B8},	{1,0x05B9},	{0,0x05BA},	{1,0x05BB},
	{1,0x05BC},	{1,0x05BD},	{0,0x05BE},	{1,0x05BF},
	{0,0x05C0},	{1,0x05C1},	{1,0x05C2},	{0,0x05C3},
	{1,0x05C4},	{0,0x05C5},	{0,0x05C6},	{0,0x05C7},
	{0,0x05C8},	{0,0x05C9},	{0,0x05CA},	{0,0x05CB},
	{0,0x05CC},	{0,0x05CD},	{0,0x05CE},	{0,0x05CF},
	{1,0x05D0},	{1,0x05D1},	{1,0x05D2},	{1,0x05D3},
	{1,0x05D4},	{1,0x05D5},	{1,0x05D6},	{1,0x05D7},
	{1,0x05D8},	{1,0x05D9},	{1,0x05DA},	{1,0x05DB},
	{1,0x05DC},	{1,0x05DD},	{1,0x05DE},	{1,0x05DF},
	{1,0x05E0},	{1,0x05E1},	{1,0x05E2},	{1,0x05E3},
	{1,0x05E4},	{1,0x05E5},	{1,0x05E6},	{1,0x05E7},
	{1,0x05E8},	{1,0x05E9},	{1,0x05EA},	{0,0x05EB},
	{0,0x05EC},	{0,0x05ED},	{0,0x05EE},	{0,0x05EF},
	{1,0x05F0},	{1,0x05F1},	{1,0x05F2},	{0,0x05F3},
	{0,0x05F4},	{0,0x05F5},	{0,0x05F6},	{0,0x05F7},
	{0,0x05F8},	{0,0x05F9},	{0,0x05FA},	{0,0x05FB},
	{0,0x05FC},	{0,0x05FD},	{0,0x05FE},	{0,0x05FF},
{0,0}};

static UDM_UNICODE plane06[257]={
	{0,0x0600},	{0,0x0601},	{0,0x0602},	{0,0x0603},
	{0,0x0604},	{0,0x0605},	{0,0x0606},	{0,0x0607},
	{0,0x0608},	{0,0x0609},	{0,0x060A},	{0,0x060B},
	{0,0x060C},	{0,0x060D},	{0,0x060E},	{0,0x060F},
	{0,0x0610},	{0,0x0611},	{0,0x0612},	{0,0x0613},
	{0,0x0614},	{0,0x0615},	{0,0x0616},	{0,0x0617},
	{0,0x0618},	{0,0x0619},	{0,0x061A},	{0,0x061B},
	{0,0x061C},	{0,0x061D},	{0,0x061E},	{0,0x061F},
	{0,0x0620},	{1,0x0621},	{1,0x0622},	{1,0x0623},
	{1,0x0624},	{1,0x0625},	{1,0x0626},	{1,0x0627},
	{1,0x0628},	{1,0x0629},	{1,0x062A},	{1,0x062B},
	{1,0x062C},	{1,0x062D},	{1,0x062E},	{1,0x062F},
	{1,0x0630},	{1,0x0631},	{1,0x0632},	{1,0x0633},
	{1,0x0634},	{1,0x0635},	{1,0x0636},	{1,0x0637},
	{1,0x0638},	{1,0x0639},	{1,0x063A},	{0,0x063B},
	{0,0x063C},	{0,0x063D},	{0,0x063E},	{0,0x063F},
	{1,0x0640},	{1,0x0641},	{1,0x0642},	{1,0x0643},
	{1,0x0644},	{1,0x0645},	{1,0x0646},	{1,0x0647},
	{1,0x0648},	{1,0x0649},	{1,0x064A},	{1,0x064B},
	{1,0x064C},	{1,0x064D},	{1,0x064E},	{1,0x064F},
	{1,0x0650},	{1,0x0651},	{1,0x0652},	{1,0x0653},
	{1,0x0654},	{1,0x0655},	{0,0x0656},	{0,0x0657},
	{0,0x0658},	{0,0x0659},	{0,0x065A},	{0,0x065B},
	{0,0x065C},	{0,0x065D},	{0,0x065E},	{0,0x065F},
	{2,0x0660},	{2,0x0661},	{2,0x0662},	{2,0x0663},
	{2,0x0664},	{2,0x0665},	{2,0x0666},	{2,0x0667},
	{2,0x0668},	{2,0x0669},	{0,0x066A},	{0,0x066B},
	{0,0x066C},	{0,0x066D},	{0,0x066E},	{0,0x066F},
	{1,0x0670},	{1,0x0671},	{1,0x0672},	{1,0x0673},
	{1,0x0674},	{1,0x0675},	{1,0x0676},	{1,0x0677},
	{1,0x0678},	{1,0x0679},	{1,0x067A},	{1,0x067B},
	{1,0x067C},	{1,0x067D},	{1,0x067E},	{1,0x067F},
	{1,0x0680},	{1,0x0681},	{1,0x0682},	{1,0x0683},
	{1,0x0684},	{1,0x0685},	{1,0x0686},	{1,0x0687},
	{1,0x0688},	{1,0x0689},	{1,0x068A},	{1,0x068B},
	{1,0x068C},	{1,0x068D},	{1,0x068E},	{1,0x068F},
	{1,0x0690},	{1,0x0691},	{1,0x0692},	{1,0x0693},
	{1,0x0694},	{1,0x0695},	{1,0x0696},	{1,0x0697},
	{1,0x0698},	{1,0x0699},	{1,0x069A},	{1,0x069B},
	{1,0x069C},	{1,0x069D},	{1,0x069E},	{1,0x069F},
	{1,0x06A0},	{1,0x06A1},	{1,0x06A2},	{1,0x06A3},
	{1,0x06A4},	{1,0x06A5},	{1,0x06A6},	{1,0x06A7},
	{1,0x06A8},	{1,0x06A9},	{1,0x06AA},	{1,0x06AB},
	{1,0x06AC},	{1,0x06AD},	{1,0x06AE},	{1,0x06AF},
	{1,0x06B0},	{1,0x06B1},	{1,0x06B2},	{1,0x06B3},
	{1,0x06B4},	{1,0x06B5},	{1,0x06B6},	{1,0x06B7},
	{1,0x06B8},	{1,0x06B9},	{1,0x06BA},	{1,0x06BB},
	{1,0x06BC},	{1,0x06BD},	{1,0x06BE},	{1,0x06BF},
	{1,0x06C0},	{1,0x06C1},	{1,0x06C2},	{1,0x06C3},
	{1,0x06C4},	{1,0x06C5},	{1,0x06C6},	{1,0x06C7},
	{1,0x06C8},	{1,0x06C9},	{1,0x06CA},	{1,0x06CB},
	{1,0x06CC},	{1,0x06CD},	{1,0x06CE},	{1,0x06CF},
	{1,0x06D0},	{1,0x06D1},	{1,0x06D2},	{1,0x06D3},
	{0,0x06D4},	{1,0x06D5},	{1,0x06D6},	{1,0x06D7},
	{1,0x06D8},	{1,0x06D9},	{1,0x06DA},	{1,0x06DB},
	{1,0x06DC},	{0,0x06DD},	{0,0x06DE},	{1,0x06DF},
	{1,0x06E0},	{1,0x06E1},	{1,0x06E2},	{1,0x06E3},
	{1,0x06E4},	{1,0x06E5},	{1,0x06E6},	{1,0x06E7},
	{1,0x06E8},	{0,0x06E9},	{1,0x06EA},	{1,0x06EB},
	{1,0x06EC},	{1,0x06ED},	{0,0x06EE},	{0,0x06EF},
	{2,0x06F0},	{2,0x06F1},	{2,0x06F2},	{2,0x06F3},
	{2,0x06F4},	{2,0x06F5},	{2,0x06F6},	{2,0x06F7},
	{2,0x06F8},	{2,0x06F9},	{1,0x06FA},	{1,0x06FB},
	{1,0x06FC},	{0,0x06FD},	{0,0x06FE},	{0,0x06FF},
{0,0}};

static UDM_UNICODE plane07[257]={
	{0,0x0700},	{0,0x0701},	{0,0x0702},	{0,0x0703},
	{0,0x0704},	{0,0x0705},	{0,0x0706},	{0,0x0707},
	{0,0x0708},	{0,0x0709},	{0,0x070A},	{0,0x070B},
	{0,0x070C},	{0,0x070D},	{0,0x070E},	{0,0x070F},
	{1,0x0710},	{1,0x0711},	{1,0x0712},	{1,0x0713},
	{1,0x0714},	{1,0x0715},	{1,0x0716},	{1,0x0717},
	{1,0x0718},	{1,0x0719},	{1,0x071A},	{1,0x071B},
	{1,0x071C},	{1,0x071D},	{1,0x071E},	{1,0x071F},
	{1,0x0720},	{1,0x0721},	{1,0x0722},	{1,0x0723},
	{1,0x0724},	{1,0x0725},	{1,0x0726},	{1,0x0727},
	{1,0x0728},	{1,0x0729},	{1,0x072A},	{1,0x072B},
	{1,0x072C},	{0,0x072D},	{0,0x072E},	{0,0x072F},
	{1,0x0730},	{1,0x0731},	{1,0x0732},	{1,0x0733},
	{1,0x0734},	{1,0x0735},	{1,0x0736},	{1,0x0737},
	{1,0x0738},	{1,0x0739},	{1,0x073A},	{1,0x073B},
	{1,0x073C},	{1,0x073D},	{1,0x073E},	{1,0x073F},
	{1,0x0740},	{1,0x0741},	{1,0x0742},	{1,0x0743},
	{1,0x0744},	{1,0x0745},	{1,0x0746},	{1,0x0747},
	{1,0x0748},	{1,0x0749},	{1,0x074A},	{0,0x074B},
	{0,0x074C},	{0,0x074D},	{0,0x074E},	{0,0x074F},
	{0,0x0750},	{0,0x0751},	{0,0x0752},	{0,0x0753},
	{0,0x0754},	{0,0x0755},	{0,0x0756},	{0,0x0757},
	{0,0x0758},	{0,0x0759},	{0,0x075A},	{0,0x075B},
	{0,0x075C},	{0,0x075D},	{0,0x075E},	{0,0x075F},
	{0,0x0760},	{0,0x0761},	{0,0x0762},	{0,0x0763},
	{0,0x0764},	{0,0x0765},	{0,0x0766},	{0,0x0767},
	{0,0x0768},	{0,0x0769},	{0,0x076A},	{0,0x076B},
	{0,0x076C},	{0,0x076D},	{0,0x076E},	{0,0x076F},
	{0,0x0770},	{0,0x0771},	{0,0x0772},	{0,0x0773},
	{0,0x0774},	{0,0x0775},	{0,0x0776},	{0,0x0777},
	{0,0x0778},	{0,0x0779},	{0,0x077A},	{0,0x077B},
	{0,0x077C},	{0,0x077D},	{0,0x077E},	{0,0x077F},
	{1,0x0780},	{1,0x0781},	{1,0x0782},	{1,0x0783},
	{1,0x0784},	{1,0x0785},	{1,0x0786},	{1,0x0787},
	{1,0x0788},	{1,0x0789},	{1,0x078A},	{1,0x078B},
	{1,0x078C},	{1,0x078D},	{1,0x078E},	{1,0x078F},
	{1,0x0790},	{1,0x0791},	{1,0x0792},	{1,0x0793},
	{1,0x0794},	{1,0x0795},	{1,0x0796},	{1,0x0797},
	{1,0x0798},	{1,0x0799},	{1,0x079A},	{1,0x079B},
	{1,0x079C},	{1,0x079D},	{1,0x079E},	{1,0x079F},
	{1,0x07A0},	{1,0x07A1},	{1,0x07A2},	{1,0x07A3},
	{1,0x07A4},	{1,0x07A5},	{1,0x07A6},	{1,0x07A7},
	{1,0x07A8},	{1,0x07A9},	{1,0x07AA},	{1,0x07AB},
	{1,0x07AC},	{1,0x07AD},	{1,0x07AE},	{1,0x07AF},
	{1,0x07B0},	{0,0x07B1},	{0,0x07B2},	{0,0x07B3},
	{0,0x07B4},	{0,0x07B5},	{0,0x07B6},	{0,0x07B7},
	{0,0x07B8},	{0,0x07B9},	{0,0x07BA},	{0,0x07BB},
	{0,0x07BC},	{0,0x07BD},	{0,0x07BE},	{0,0x07BF},
	{0,0x07C0},	{0,0x07C1},	{0,0x07C2},	{0,0x07C3},
	{0,0x07C4},	{0,0x07C5},	{0,0x07C6},	{0,0x07C7},
	{0,0x07C8},	{0,0x07C9},	{0,0x07CA},	{0,0x07CB},
	{0,0x07CC},	{0,0x07CD},	{0,0x07CE},	{0,0x07CF},
	{0,0x07D0},	{0,0x07D1},	{0,0x07D2},	{0,0x07D3},
	{0,0x07D4},	{0,0x07D5},	{0,0x07D6},	{0,0x07D7},
	{0,0x07D8},	{0,0x07D9},	{0,0x07DA},	{0,0x07DB},
	{0,0x07DC},	{0,0x07DD},	{0,0x07DE},	{0,0x07DF},
	{0,0x07E0},	{0,0x07E1},	{0,0x07E2},	{0,0x07E3},
	{0,0x07E4},	{0,0x07E5},	{0,0x07E6},	{0,0x07E7},
	{0,0x07E8},	{0,0x07E9},	{0,0x07EA},	{0,0x07EB},
	{0,0x07EC},	{0,0x07ED},	{0,0x07EE},	{0,0x07EF},
	{0,0x07F0},	{0,0x07F1},	{0,0x07F2},	{0,0x07F3},
	{0,0x07F4},	{0,0x07F5},	{0,0x07F6},	{0,0x07F7},
	{0,0x07F8},	{0,0x07F9},	{0,0x07FA},	{0,0x07FB},
	{0,0x07FC},	{0,0x07FD},	{0,0x07FE},	{0,0x07FF},
{0,0}};

static UDM_UNICODE plane09[257]={
	{0,0x0900},	{1,0x0901},	{1,0x0902},	{0,0x0903},
	{0,0x0904},	{1,0x0905},	{1,0x0906},	{1,0x0907},
	{1,0x0908},	{1,0x0909},	{1,0x090A},	{1,0x090B},
	{1,0x090C},	{1,0x090D},	{1,0x090E},	{1,0x090F},
	{1,0x0910},	{1,0x0911},	{1,0x0912},	{1,0x0913},
	{1,0x0914},	{1,0x0915},	{1,0x0916},	{1,0x0917},
	{1,0x0918},	{1,0x0919},	{1,0x091A},	{1,0x091B},
	{1,0x091C},	{1,0x091D},	{1,0x091E},	{1,0x091F},
	{1,0x0920},	{1,0x0921},	{1,0x0922},	{1,0x0923},
	{1,0x0924},	{1,0x0925},	{1,0x0926},	{1,0x0927},
	{1,0x0928},	{1,0x0929},	{1,0x092A},	{1,0x092B},
	{1,0x092C},	{1,0x092D},	{1,0x092E},	{1,0x092F},
	{1,0x0930},	{1,0x0931},	{1,0x0932},	{1,0x0933},
	{1,0x0934},	{1,0x0935},	{1,0x0936},	{1,0x0937},
	{1,0x0938},	{1,0x0939},	{0,0x093A},	{0,0x093B},
	{1,0x093C},	{1,0x093D},	{0,0x093E},	{0,0x093F},
	{0,0x0940},	{1,0x0941},	{1,0x0942},	{1,0x0943},
	{1,0x0944},	{1,0x0945},	{1,0x0946},	{1,0x0947},
	{1,0x0948},	{0,0x0949},	{0,0x094A},	{0,0x094B},
	{0,0x094C},	{1,0x094D},	{0,0x094E},	{0,0x094F},
	{1,0x0950},	{1,0x0951},	{1,0x0952},	{1,0x0953},
	{1,0x0954},	{0,0x0955},	{0,0x0956},	{0,0x0957},
	{1,0x0958},	{1,0x0959},	{1,0x095A},	{1,0x095B},
	{1,0x095C},	{1,0x095D},	{1,0x095E},	{1,0x095F},
	{1,0x0960},	{1,0x0961},	{1,0x0962},	{1,0x0963},
	{0,0x0964},	{0,0x0965},	{2,0x0966},	{2,0x0967},
	{2,0x0968},	{2,0x0969},	{2,0x096A},	{2,0x096B},
	{2,0x096C},	{2,0x096D},	{2,0x096E},	{2,0x096F},
	{0,0x0970},	{0,0x0971},	{0,0x0972},	{0,0x0973},
	{0,0x0974},	{0,0x0975},	{0,0x0976},	{0,0x0977},
	{0,0x0978},	{0,0x0979},	{0,0x097A},	{0,0x097B},
	{0,0x097C},	{0,0x097D},	{0,0x097E},	{0,0x097F},
	{0,0x0980},	{1,0x0981},	{0,0x0982},	{0,0x0983},
	{0,0x0984},	{1,0x0985},	{1,0x0986},	{1,0x0987},
	{1,0x0988},	{1,0x0989},	{1,0x098A},	{1,0x098B},
	{1,0x098C},	{0,0x098D},	{0,0x098E},	{1,0x098F},
	{1,0x0990},	{0,0x0991},	{0,0x0992},	{1,0x0993},
	{1,0x0994},	{1,0x0995},	{1,0x0996},	{1,0x0997},
	{1,0x0998},	{1,0x0999},	{1,0x099A},	{1,0x099B},
	{1,0x099C},	{1,0x099D},	{1,0x099E},	{1,0x099F},
	{1,0x09A0},	{1,0x09A1},	{1,0x09A2},	{1,0x09A3},
	{1,0x09A4},	{1,0x09A5},	{1,0x09A6},	{1,0x09A7},
	{1,0x09A8},	{0,0x09A9},	{1,0x09AA},	{1,0x09AB},
	{1,0x09AC},	{1,0x09AD},	{1,0x09AE},	{1,0x09AF},
	{1,0x09B0},	{0,0x09B1},	{1,0x09B2},	{0,0x09B3},
	{0,0x09B4},	{0,0x09B5},	{1,0x09B6},	{1,0x09B7},
	{1,0x09B8},	{1,0x09B9},	{0,0x09BA},	{0,0x09BB},
	{1,0x09BC},	{0,0x09BD},	{0,0x09BE},	{0,0x09BF},
	{0,0x09C0},	{1,0x09C1},	{1,0x09C2},	{1,0x09C3},
	{1,0x09C4},	{0,0x09C5},	{0,0x09C6},	{0,0x09C7},
	{0,0x09C8},	{0,0x09C9},	{0,0x09CA},	{0,0x09CB},
	{0,0x09CC},	{1,0x09CD},	{0,0x09CE},	{0,0x09CF},
	{0,0x09D0},	{0,0x09D1},	{0,0x09D2},	{0,0x09D3},
	{0,0x09D4},	{0,0x09D5},	{0,0x09D6},	{0,0x09D7},
	{0,0x09D8},	{0,0x09D9},	{0,0x09DA},	{0,0x09DB},
	{1,0x09DC},	{1,0x09DD},	{0,0x09DE},	{1,0x09DF},
	{1,0x09E0},	{1,0x09E1},	{1,0x09E2},	{1,0x09E3},
	{0,0x09E4},	{0,0x09E5},	{2,0x09E6},	{2,0x09E7},
	{2,0x09E8},	{2,0x09E9},	{2,0x09EA},	{2,0x09EB},
	{2,0x09EC},	{2,0x09ED},	{2,0x09EE},	{2,0x09EF},
	{1,0x09F0},	{1,0x09F1},	{0,0x09F2},	{0,0x09F3},
	{0,0x09F4},	{0,0x09F5},	{0,0x09F6},	{0,0x09F7},
	{0,0x09F8},	{0,0x09F9},	{0,0x09FA},	{0,0x09FB},
	{0,0x09FC},	{0,0x09FD},	{0,0x09FE},	{0,0x09FF},
{0,0}};

static UDM_UNICODE plane0A[257]={
	{0,0x0A00},	{0,0x0A01},	{1,0x0A02},	{0,0x0A03},
	{0,0x0A04},	{1,0x0A05},	{1,0x0A06},	{1,0x0A07},
	{1,0x0A08},	{1,0x0A09},	{1,0x0A0A},	{0,0x0A0B},
	{0,0x0A0C},	{0,0x0A0D},	{0,0x0A0E},	{1,0x0A0F},
	{1,0x0A10},	{0,0x0A11},	{0,0x0A12},	{1,0x0A13},
	{1,0x0A14},	{1,0x0A15},	{1,0x0A16},	{1,0x0A17},
	{1,0x0A18},	{1,0x0A19},	{1,0x0A1A},	{1,0x0A1B},
	{1,0x0A1C},	{1,0x0A1D},	{1,0x0A1E},	{1,0x0A1F},
	{1,0x0A20},	{1,0x0A21},	{1,0x0A22},	{1,0x0A23},
	{1,0x0A24},	{1,0x0A25},	{1,0x0A26},	{1,0x0A27},
	{1,0x0A28},	{0,0x0A29},	{1,0x0A2A},	{1,0x0A2B},
	{1,0x0A2C},	{1,0x0A2D},	{1,0x0A2E},	{1,0x0A2F},
	{1,0x0A30},	{0,0x0A31},	{1,0x0A32},	{1,0x0A33},
	{0,0x0A34},	{1,0x0A35},	{1,0x0A36},	{0,0x0A37},
	{1,0x0A38},	{1,0x0A39},	{0,0x0A3A},	{0,0x0A3B},
	{1,0x0A3C},	{0,0x0A3D},	{0,0x0A3E},	{0,0x0A3F},
	{0,0x0A40},	{1,0x0A41},	{1,0x0A42},	{0,0x0A43},
	{0,0x0A44},	{0,0x0A45},	{0,0x0A46},	{1,0x0A47},
	{1,0x0A48},	{0,0x0A49},	{0,0x0A4A},	{1,0x0A4B},
	{1,0x0A4C},	{1,0x0A4D},	{0,0x0A4E},	{0,0x0A4F},
	{0,0x0A50},	{0,0x0A51},	{0,0x0A52},	{0,0x0A53},
	{0,0x0A54},	{0,0x0A55},	{0,0x0A56},	{0,0x0A57},
	{0,0x0A58},	{1,0x0A59},	{1,0x0A5A},	{1,0x0A5B},
	{1,0x0A5C},	{0,0x0A5D},	{1,0x0A5E},	{0,0x0A5F},
	{0,0x0A60},	{0,0x0A61},	{0,0x0A62},	{0,0x0A63},
	{0,0x0A64},	{0,0x0A65},	{2,0x0A66},	{2,0x0A67},
	{2,0x0A68},	{2,0x0A69},	{2,0x0A6A},	{2,0x0A6B},
	{2,0x0A6C},	{2,0x0A6D},	{2,0x0A6E},	{2,0x0A6F},
	{1,0x0A70},	{1,0x0A71},	{1,0x0A72},	{1,0x0A73},
	{1,0x0A74},	{0,0x0A75},	{0,0x0A76},	{0,0x0A77},
	{0,0x0A78},	{0,0x0A79},	{0,0x0A7A},	{0,0x0A7B},
	{0,0x0A7C},	{0,0x0A7D},	{0,0x0A7E},	{0,0x0A7F},
	{0,0x0A80},	{1,0x0A81},	{1,0x0A82},	{0,0x0A83},
	{0,0x0A84},	{1,0x0A85},	{1,0x0A86},	{1,0x0A87},
	{1,0x0A88},	{1,0x0A89},	{1,0x0A8A},	{1,0x0A8B},
	{0,0x0A8C},	{1,0x0A8D},	{0,0x0A8E},	{1,0x0A8F},
	{1,0x0A90},	{1,0x0A91},	{0,0x0A92},	{1,0x0A93},
	{1,0x0A94},	{1,0x0A95},	{1,0x0A96},	{1,0x0A97},
	{1,0x0A98},	{1,0x0A99},	{1,0x0A9A},	{1,0x0A9B},
	{1,0x0A9C},	{1,0x0A9D},	{1,0x0A9E},	{1,0x0A9F},
	{1,0x0AA0},	{1,0x0AA1},	{1,0x0AA2},	{1,0x0AA3},
	{1,0x0AA4},	{1,0x0AA5},	{1,0x0AA6},	{1,0x0AA7},
	{1,0x0AA8},	{0,0x0AA9},	{1,0x0AAA},	{1,0x0AAB},
	{1,0x0AAC},	{1,0x0AAD},	{1,0x0AAE},	{1,0x0AAF},
	{1,0x0AB0},	{0,0x0AB1},	{1,0x0AB2},	{1,0x0AB3},
	{0,0x0AB4},	{1,0x0AB5},	{1,0x0AB6},	{1,0x0AB7},
	{1,0x0AB8},	{1,0x0AB9},	{0,0x0ABA},	{0,0x0ABB},
	{1,0x0ABC},	{1,0x0ABD},	{0,0x0ABE},	{0,0x0ABF},
	{0,0x0AC0},	{1,0x0AC1},	{1,0x0AC2},	{1,0x0AC3},
	{1,0x0AC4},	{1,0x0AC5},	{0,0x0AC6},	{1,0x0AC7},
	{1,0x0AC8},	{0,0x0AC9},	{0,0x0ACA},	{0,0x0ACB},
	{0,0x0ACC},	{1,0x0ACD},	{0,0x0ACE},	{0,0x0ACF},
	{1,0x0AD0},	{0,0x0AD1},	{0,0x0AD2},	{0,0x0AD3},
	{0,0x0AD4},	{0,0x0AD5},	{0,0x0AD6},	{0,0x0AD7},
	{0,0x0AD8},	{0,0x0AD9},	{0,0x0ADA},	{0,0x0ADB},
	{0,0x0ADC},	{0,0x0ADD},	{0,0x0ADE},	{0,0x0ADF},
	{1,0x0AE0},	{0,0x0AE1},	{0,0x0AE2},	{0,0x0AE3},
	{0,0x0AE4},	{0,0x0AE5},	{2,0x0AE6},	{2,0x0AE7},
	{2,0x0AE8},	{2,0x0AE9},	{2,0x0AEA},	{2,0x0AEB},
	{2,0x0AEC},	{2,0x0AED},	{2,0x0AEE},	{2,0x0AEF},
	{0,0x0AF0},	{0,0x0AF1},	{0,0x0AF2},	{0,0x0AF3},
	{0,0x0AF4},	{0,0x0AF5},	{0,0x0AF6},	{0,0x0AF7},
	{0,0x0AF8},	{0,0x0AF9},	{0,0x0AFA},	{0,0x0AFB},
	{0,0x0AFC},	{0,0x0AFD},	{0,0x0AFE},	{0,0x0AFF},
{0,0}};

static UDM_UNICODE plane0B[257]={
	{0,0x0B00},	{1,0x0B01},	{0,0x0B02},	{0,0x0B03},
	{0,0x0B04},	{1,0x0B05},	{1,0x0B06},	{1,0x0B07},
	{1,0x0B08},	{1,0x0B09},	{1,0x0B0A},	{1,0x0B0B},
	{1,0x0B0C},	{0,0x0B0D},	{0,0x0B0E},	{1,0x0B0F},
	{1,0x0B10},	{0,0x0B11},	{0,0x0B12},	{1,0x0B13},
	{1,0x0B14},	{1,0x0B15},	{1,0x0B16},	{1,0x0B17},
	{1,0x0B18},	{1,0x0B19},	{1,0x0B1A},	{1,0x0B1B},
	{1,0x0B1C},	{1,0x0B1D},	{1,0x0B1E},	{1,0x0B1F},
	{1,0x0B20},	{1,0x0B21},	{1,0x0B22},	{1,0x0B23},
	{1,0x0B24},	{1,0x0B25},	{1,0x0B26},	{1,0x0B27},
	{1,0x0B28},	{0,0x0B29},	{1,0x0B2A},	{1,0x0B2B},
	{1,0x0B2C},	{1,0x0B2D},	{1,0x0B2E},	{1,0x0B2F},
	{1,0x0B30},	{0,0x0B31},	{1,0x0B32},	{1,0x0B33},
	{0,0x0B34},	{0,0x0B35},	{1,0x0B36},	{1,0x0B37},
	{1,0x0B38},	{1,0x0B39},	{0,0x0B3A},	{0,0x0B3B},
	{1,0x0B3C},	{1,0x0B3D},	{0,0x0B3E},	{1,0x0B3F},
	{0,0x0B40},	{1,0x0B41},	{1,0x0B42},	{1,0x0B43},
	{0,0x0B44},	{0,0x0B45},	{0,0x0B46},	{0,0x0B47},
	{0,0x0B48},	{0,0x0B49},	{0,0x0B4A},	{0,0x0B4B},
	{0,0x0B4C},	{1,0x0B4D},	{0,0x0B4E},	{0,0x0B4F},
	{0,0x0B50},	{0,0x0B51},	{0,0x0B52},	{0,0x0B53},
	{0,0x0B54},	{0,0x0B55},	{1,0x0B56},	{0,0x0B57},
	{0,0x0B58},	{0,0x0B59},	{0,0x0B5A},	{0,0x0B5B},
	{1,0x0B5C},	{1,0x0B5D},	{0,0x0B5E},	{1,0x0B5F},
	{1,0x0B60},	{1,0x0B61},	{0,0x0B62},	{0,0x0B63},
	{0,0x0B64},	{0,0x0B65},	{2,0x0B66},	{2,0x0B67},
	{2,0x0B68},	{2,0x0B69},	{2,0x0B6A},	{2,0x0B6B},
	{2,0x0B6C},	{2,0x0B6D},	{2,0x0B6E},	{2,0x0B6F},
	{0,0x0B70},	{0,0x0B71},	{0,0x0B72},	{0,0x0B73},
	{0,0x0B74},	{0,0x0B75},	{0,0x0B76},	{0,0x0B77},
	{0,0x0B78},	{0,0x0B79},	{0,0x0B7A},	{0,0x0B7B},
	{0,0x0B7C},	{0,0x0B7D},	{0,0x0B7E},	{0,0x0B7F},
	{0,0x0B80},	{0,0x0B81},	{1,0x0B82},	{0,0x0B83},
	{0,0x0B84},	{1,0x0B85},	{1,0x0B86},	{1,0x0B87},
	{1,0x0B88},	{1,0x0B89},	{1,0x0B8A},	{0,0x0B8B},
	{0,0x0B8C},	{0,0x0B8D},	{1,0x0B8E},	{1,0x0B8F},
	{1,0x0B90},	{0,0x0B91},	{1,0x0B92},	{1,0x0B93},
	{1,0x0B94},	{1,0x0B95},	{0,0x0B96},	{0,0x0B97},
	{0,0x0B98},	{1,0x0B99},	{1,0x0B9A},	{0,0x0B9B},
	{1,0x0B9C},	{0,0x0B9D},	{1,0x0B9E},	{1,0x0B9F},
	{0,0x0BA0},	{0,0x0BA1},	{0,0x0BA2},	{1,0x0BA3},
	{1,0x0BA4},	{0,0x0BA5},	{0,0x0BA6},	{0,0x0BA7},
	{1,0x0BA8},	{1,0x0BA9},	{1,0x0BAA},	{0,0x0BAB},
	{0,0x0BAC},	{0,0x0BAD},	{1,0x0BAE},	{1,0x0BAF},
	{1,0x0BB0},	{1,0x0BB1},	{1,0x0BB2},	{1,0x0BB3},
	{1,0x0BB4},	{1,0x0BB5},	{0,0x0BB6},	{1,0x0BB7},
	{1,0x0BB8},	{1,0x0BB9},	{0,0x0BBA},	{0,0x0BBB},
	{0,0x0BBC},	{0,0x0BBD},	{0,0x0BBE},	{0,0x0BBF},
	{1,0x0BC0},	{0,0x0BC1},	{0,0x0BC2},	{0,0x0BC3},
	{0,0x0BC4},	{0,0x0BC5},	{0,0x0BC6},	{0,0x0BC7},
	{0,0x0BC8},	{0,0x0BC9},	{0,0x0BCA},	{0,0x0BCB},
	{0,0x0BCC},	{1,0x0BCD},	{0,0x0BCE},	{0,0x0BCF},
	{0,0x0BD0},	{0,0x0BD1},	{0,0x0BD2},	{0,0x0BD3},
	{0,0x0BD4},	{0,0x0BD5},	{0,0x0BD6},	{0,0x0BD7},
	{0,0x0BD8},	{0,0x0BD9},	{0,0x0BDA},	{0,0x0BDB},
	{0,0x0BDC},	{0,0x0BDD},	{0,0x0BDE},	{0,0x0BDF},
	{0,0x0BE0},	{0,0x0BE1},	{0,0x0BE2},	{0,0x0BE3},
	{0,0x0BE4},	{0,0x0BE5},	{0,0x0BE6},	{2,0x0BE7},
	{2,0x0BE8},	{2,0x0BE9},	{2,0x0BEA},	{2,0x0BEB},
	{2,0x0BEC},	{2,0x0BED},	{2,0x0BEE},	{2,0x0BEF},
	{0,0x0BF0},	{0,0x0BF1},	{0,0x0BF2},	{0,0x0BF3},
	{0,0x0BF4},	{0,0x0BF5},	{0,0x0BF6},	{0,0x0BF7},
	{0,0x0BF8},	{0,0x0BF9},	{0,0x0BFA},	{0,0x0BFB},
	{0,0x0BFC},	{0,0x0BFD},	{0,0x0BFE},	{0,0x0BFF},
{0,0}};

static UDM_UNICODE plane0C[257]={
	{0,0x0C00},	{0,0x0C01},	{0,0x0C02},	{0,0x0C03},
	{0,0x0C04},	{1,0x0C05},	{1,0x0C06},	{1,0x0C07},
	{1,0x0C08},	{1,0x0C09},	{1,0x0C0A},	{1,0x0C0B},
	{1,0x0C0C},	{0,0x0C0D},	{1,0x0C0E},	{1,0x0C0F},
	{1,0x0C10},	{0,0x0C11},	{1,0x0C12},	{1,0x0C13},
	{1,0x0C14},	{1,0x0C15},	{1,0x0C16},	{1,0x0C17},
	{1,0x0C18},	{1,0x0C19},	{1,0x0C1A},	{1,0x0C1B},
	{1,0x0C1C},	{1,0x0C1D},	{1,0x0C1E},	{1,0x0C1F},
	{1,0x0C20},	{1,0x0C21},	{1,0x0C22},	{1,0x0C23},
	{1,0x0C24},	{1,0x0C25},	{1,0x0C26},	{1,0x0C27},
	{1,0x0C28},	{0,0x0C29},	{1,0x0C2A},	{1,0x0C2B},
	{1,0x0C2C},	{1,0x0C2D},	{1,0x0C2E},	{1,0x0C2F},
	{1,0x0C30},	{1,0x0C31},	{1,0x0C32},	{1,0x0C33},
	{0,0x0C34},	{1,0x0C35},	{1,0x0C36},	{1,0x0C37},
	{1,0x0C38},	{1,0x0C39},	{0,0x0C3A},	{0,0x0C3B},
	{0,0x0C3C},	{0,0x0C3D},	{1,0x0C3E},	{1,0x0C3F},
	{1,0x0C40},	{0,0x0C41},	{0,0x0C42},	{0,0x0C43},
	{0,0x0C44},	{0,0x0C45},	{1,0x0C46},	{1,0x0C47},
	{1,0x0C48},	{0,0x0C49},	{1,0x0C4A},	{1,0x0C4B},
	{1,0x0C4C},	{1,0x0C4D},	{0,0x0C4E},	{0,0x0C4F},
	{0,0x0C50},	{0,0x0C51},	{0,0x0C52},	{0,0x0C53},
	{0,0x0C54},	{1,0x0C55},	{1,0x0C56},	{0,0x0C57},
	{0,0x0C58},	{0,0x0C59},	{0,0x0C5A},	{0,0x0C5B},
	{0,0x0C5C},	{0,0x0C5D},	{0,0x0C5E},	{0,0x0C5F},
	{1,0x0C60},	{1,0x0C61},	{0,0x0C62},	{0,0x0C63},
	{0,0x0C64},	{0,0x0C65},	{2,0x0C66},	{2,0x0C67},
	{2,0x0C68},	{2,0x0C69},	{2,0x0C6A},	{2,0x0C6B},
	{2,0x0C6C},	{2,0x0C6D},	{2,0x0C6E},	{2,0x0C6F},
	{0,0x0C70},	{0,0x0C71},	{0,0x0C72},	{0,0x0C73},
	{0,0x0C74},	{0,0x0C75},	{0,0x0C76},	{0,0x0C77},
	{0,0x0C78},	{0,0x0C79},	{0,0x0C7A},	{0,0x0C7B},
	{0,0x0C7C},	{0,0x0C7D},	{0,0x0C7E},	{0,0x0C7F},
	{0,0x0C80},	{0,0x0C81},	{0,0x0C82},	{0,0x0C83},
	{0,0x0C84},	{1,0x0C85},	{1,0x0C86},	{1,0x0C87},
	{1,0x0C88},	{1,0x0C89},	{1,0x0C8A},	{1,0x0C8B},
	{1,0x0C8C},	{0,0x0C8D},	{1,0x0C8E},	{1,0x0C8F},
	{1,0x0C90},	{0,0x0C91},	{1,0x0C92},	{1,0x0C93},
	{1,0x0C94},	{1,0x0C95},	{1,0x0C96},	{1,0x0C97},
	{1,0x0C98},	{1,0x0C99},	{1,0x0C9A},	{1,0x0C9B},
	{1,0x0C9C},	{1,0x0C9D},	{1,0x0C9E},	{1,0x0C9F},
	{1,0x0CA0},	{1,0x0CA1},	{1,0x0CA2},	{1,0x0CA3},
	{1,0x0CA4},	{1,0x0CA5},	{1,0x0CA6},	{1,0x0CA7},
	{1,0x0CA8},	{0,0x0CA9},	{1,0x0CAA},	{1,0x0CAB},
	{1,0x0CAC},	{1,0x0CAD},	{1,0x0CAE},	{1,0x0CAF},
	{1,0x0CB0},	{1,0x0CB1},	{1,0x0CB2},	{1,0x0CB3},
	{0,0x0CB4},	{1,0x0CB5},	{1,0x0CB6},	{1,0x0CB7},
	{1,0x0CB8},	{1,0x0CB9},	{0,0x0CBA},	{0,0x0CBB},
	{0,0x0CBC},	{0,0x0CBD},	{0,0x0CBE},	{1,0x0CBF},
	{0,0x0CC0},	{0,0x0CC1},	{0,0x0CC2},	{0,0x0CC3},
	{0,0x0CC4},	{0,0x0CC5},	{1,0x0CC6},	{0,0x0CC7},
	{0,0x0CC8},	{0,0x0CC9},	{0,0x0CCA},	{0,0x0CCB},
	{1,0x0CCC},	{1,0x0CCD},	{0,0x0CCE},	{0,0x0CCF},
	{0,0x0CD0},	{0,0x0CD1},	{0,0x0CD2},	{0,0x0CD3},
	{0,0x0CD4},	{0,0x0CD5},	{0,0x0CD6},	{0,0x0CD7},
	{0,0x0CD8},	{0,0x0CD9},	{0,0x0CDA},	{0,0x0CDB},
	{0,0x0CDC},	{0,0x0CDD},	{1,0x0CDE},	{0,0x0CDF},
	{1,0x0CE0},	{1,0x0CE1},	{0,0x0CE2},	{0,0x0CE3},
	{0,0x0CE4},	{0,0x0CE5},	{2,0x0CE6},	{2,0x0CE7},
	{2,0x0CE8},	{2,0x0CE9},	{2,0x0CEA},	{2,0x0CEB},
	{2,0x0CEC},	{2,0x0CED},	{2,0x0CEE},	{2,0x0CEF},
	{0,0x0CF0},	{0,0x0CF1},	{0,0x0CF2},	{0,0x0CF3},
	{0,0x0CF4},	{0,0x0CF5},	{0,0x0CF6},	{0,0x0CF7},
	{0,0x0CF8},	{0,0x0CF9},	{0,0x0CFA},	{0,0x0CFB},
	{0,0x0CFC},	{0,0x0CFD},	{0,0x0CFE},	{0,0x0CFF},
{0,0}};

static UDM_UNICODE plane0D[257]={
	{0,0x0D00},	{0,0x0D01},	{0,0x0D02},	{0,0x0D03},
	{0,0x0D04},	{1,0x0D05},	{1,0x0D06},	{1,0x0D07},
	{1,0x0D08},	{1,0x0D09},	{1,0x0D0A},	{1,0x0D0B},
	{1,0x0D0C},	{0,0x0D0D},	{1,0x0D0E},	{1,0x0D0F},
	{1,0x0D10},	{0,0x0D11},	{1,0x0D12},	{1,0x0D13},
	{1,0x0D14},	{1,0x0D15},	{1,0x0D16},	{1,0x0D17},
	{1,0x0D18},	{1,0x0D19},	{1,0x0D1A},	{1,0x0D1B},
	{1,0x0D1C},	{1,0x0D1D},	{1,0x0D1E},	{1,0x0D1F},
	{1,0x0D20},	{1,0x0D21},	{1,0x0D22},	{1,0x0D23},
	{1,0x0D24},	{1,0x0D25},	{1,0x0D26},	{1,0x0D27},
	{1,0x0D28},	{0,0x0D29},	{1,0x0D2A},	{1,0x0D2B},
	{1,0x0D2C},	{1,0x0D2D},	{1,0x0D2E},	{1,0x0D2F},
	{1,0x0D30},	{1,0x0D31},	{1,0x0D32},	{1,0x0D33},
	{1,0x0D34},	{1,0x0D35},	{1,0x0D36},	{1,0x0D37},
	{1,0x0D38},	{1,0x0D39},	{0,0x0D3A},	{0,0x0D3B},
	{0,0x0D3C},	{0,0x0D3D},	{0,0x0D3E},	{0,0x0D3F},
	{0,0x0D40},	{1,0x0D41},	{1,0x0D42},	{1,0x0D43},
	{0,0x0D44},	{0,0x0D45},	{0,0x0D46},	{0,0x0D47},
	{0,0x0D48},	{0,0x0D49},	{0,0x0D4A},	{0,0x0D4B},
	{0,0x0D4C},	{1,0x0D4D},	{0,0x0D4E},	{0,0x0D4F},
	{0,0x0D50},	{0,0x0D51},	{0,0x0D52},	{0,0x0D53},
	{0,0x0D54},	{0,0x0D55},	{0,0x0D56},	{0,0x0D57},
	{0,0x0D58},	{0,0x0D59},	{0,0x0D5A},	{0,0x0D5B},
	{0,0x0D5C},	{0,0x0D5D},	{0,0x0D5E},	{0,0x0D5F},
	{1,0x0D60},	{1,0x0D61},	{0,0x0D62},	{0,0x0D63},
	{0,0x0D64},	{0,0x0D65},	{2,0x0D66},	{2,0x0D67},
	{2,0x0D68},	{2,0x0D69},	{2,0x0D6A},	{2,0x0D6B},
	{2,0x0D6C},	{2,0x0D6D},	{2,0x0D6E},	{2,0x0D6F},
	{0,0x0D70},	{0,0x0D71},	{0,0x0D72},	{0,0x0D73},
	{0,0x0D74},	{0,0x0D75},	{0,0x0D76},	{0,0x0D77},
	{0,0x0D78},	{0,0x0D79},	{0,0x0D7A},	{0,0x0D7B},
	{0,0x0D7C},	{0,0x0D7D},	{0,0x0D7E},	{0,0x0D7F},
	{0,0x0D80},	{0,0x0D81},	{0,0x0D82},	{0,0x0D83},
	{0,0x0D84},	{1,0x0D85},	{1,0x0D86},	{1,0x0D87},
	{1,0x0D88},	{1,0x0D89},	{1,0x0D8A},	{1,0x0D8B},
	{1,0x0D8C},	{1,0x0D8D},	{1,0x0D8E},	{1,0x0D8F},
	{1,0x0D90},	{1,0x0D91},	{1,0x0D92},	{1,0x0D93},
	{1,0x0D94},	{1,0x0D95},	{1,0x0D96},	{0,0x0D97},
	{0,0x0D98},	{0,0x0D99},	{1,0x0D9A},	{1,0x0D9B},
	{1,0x0D9C},	{1,0x0D9D},	{1,0x0D9E},	{1,0x0D9F},
	{1,0x0DA0},	{1,0x0DA1},	{1,0x0DA2},	{1,0x0DA3},
	{1,0x0DA4},	{1,0x0DA5},	{1,0x0DA6},	{1,0x0DA7},
	{1,0x0DA8},	{1,0x0DA9},	{1,0x0DAA},	{1,0x0DAB},
	{1,0x0DAC},	{1,0x0DAD},	{1,0x0DAE},	{1,0x0DAF},
	{1,0x0DB0},	{1,0x0DB1},	{0,0x0DB2},	{1,0x0DB3},
	{1,0x0DB4},	{1,0x0DB5},	{1,0x0DB6},	{1,0x0DB7},
	{1,0x0DB8},	{1,0x0DB9},	{1,0x0DBA},	{1,0x0DBB},
	{0,0x0DBC},	{1,0x0DBD},	{0,0x0DBE},	{0,0x0DBF},
	{1,0x0DC0},	{1,0x0DC1},	{1,0x0DC2},	{1,0x0DC3},
	{1,0x0DC4},	{1,0x0DC5},	{1,0x0DC6},	{0,0x0DC7},
	{0,0x0DC8},	{0,0x0DC9},	{1,0x0DCA},	{0,0x0DCB},
	{0,0x0DCC},	{0,0x0DCD},	{0,0x0DCE},	{0,0x0DCF},
	{0,0x0DD0},	{0,0x0DD1},	{1,0x0DD2},	{1,0x0DD3},
	{1,0x0DD4},	{0,0x0DD5},	{1,0x0DD6},	{0,0x0DD7},
	{0,0x0DD8},	{0,0x0DD9},	{0,0x0DDA},	{0,0x0DDB},
	{0,0x0DDC},	{0,0x0DDD},	{0,0x0DDE},	{0,0x0DDF},
	{0,0x0DE0},	{0,0x0DE1},	{0,0x0DE2},	{0,0x0DE3},
	{0,0x0DE4},	{0,0x0DE5},	{0,0x0DE6},	{0,0x0DE7},
	{0,0x0DE8},	{0,0x0DE9},	{0,0x0DEA},	{0,0x0DEB},
	{0,0x0DEC},	{0,0x0DED},	{0,0x0DEE},	{0,0x0DEF},
	{0,0x0DF0},	{0,0x0DF1},	{0,0x0DF2},	{0,0x0DF3},
	{0,0x0DF4},	{0,0x0DF5},	{0,0x0DF6},	{0,0x0DF7},
	{0,0x0DF8},	{0,0x0DF9},	{0,0x0DFA},	{0,0x0DFB},
	{0,0x0DFC},	{0,0x0DFD},	{0,0x0DFE},	{0,0x0DFF},
{0,0}};

static UDM_UNICODE plane0E[257]={
	{0,0x0E00},	{1,0x0E01},	{1,0x0E02},	{1,0x0E03},
	{1,0x0E04},	{1,0x0E05},	{1,0x0E06},	{1,0x0E07},
	{1,0x0E08},	{1,0x0E09},	{1,0x0E0A},	{1,0x0E0B},
	{1,0x0E0C},	{1,0x0E0D},	{1,0x0E0E},	{1,0x0E0F},
	{1,0x0E10},	{1,0x0E11},	{1,0x0E12},	{1,0x0E13},
	{1,0x0E14},	{1,0x0E15},	{1,0x0E16},	{1,0x0E17},
	{1,0x0E18},	{1,0x0E19},	{1,0x0E1A},	{1,0x0E1B},
	{1,0x0E1C},	{1,0x0E1D},	{1,0x0E1E},	{1,0x0E1F},
	{1,0x0E20},	{1,0x0E21},	{1,0x0E22},	{1,0x0E23},
	{1,0x0E24},	{1,0x0E25},	{1,0x0E26},	{1,0x0E27},
	{1,0x0E28},	{1,0x0E29},	{1,0x0E2A},	{1,0x0E2B},
	{1,0x0E2C},	{1,0x0E2D},	{1,0x0E2E},	{1,0x0E2F},
	{1,0x0E30},	{1,0x0E31},	{1,0x0E32},	{1,0x0E33},
	{1,0x0E34},	{1,0x0E35},	{1,0x0E36},	{1,0x0E37},
	{1,0x0E38},	{1,0x0E39},	{1,0x0E3A},	{0,0x0E3B},
	{0,0x0E3C},	{0,0x0E3D},	{0,0x0E3E},	{0,0x0E3F},
	{1,0x0E40},	{1,0x0E41},	{1,0x0E42},	{1,0x0E43},
	{1,0x0E44},	{1,0x0E45},	{1,0x0E46},	{1,0x0E47},
	{1,0x0E48},	{1,0x0E49},	{1,0x0E4A},	{1,0x0E4B},
	{1,0x0E4C},	{1,0x0E4D},	{1,0x0E4E},	{0,0x0E4F},
	{2,0x0E50},	{2,0x0E51},	{2,0x0E52},	{2,0x0E53},
	{2,0x0E54},	{2,0x0E55},	{2,0x0E56},	{2,0x0E57},
	{2,0x0E58},	{2,0x0E59},	{0,0x0E5A},	{0,0x0E5B},
	{0,0x0E5C},	{0,0x0E5D},	{0,0x0E5E},	{0,0x0E5F},
	{0,0x0E60},	{0,0x0E61},	{0,0x0E62},	{0,0x0E63},
	{0,0x0E64},	{0,0x0E65},	{0,0x0E66},	{0,0x0E67},
	{0,0x0E68},	{0,0x0E69},	{0,0x0E6A},	{0,0x0E6B},
	{0,0x0E6C},	{0,0x0E6D},	{0,0x0E6E},	{0,0x0E6F},
	{0,0x0E70},	{0,0x0E71},	{0,0x0E72},	{0,0x0E73},
	{0,0x0E74},	{0,0x0E75},	{0,0x0E76},	{0,0x0E77},
	{0,0x0E78},	{0,0x0E79},	{0,0x0E7A},	{0,0x0E7B},
	{0,0x0E7C},	{0,0x0E7D},	{0,0x0E7E},	{0,0x0E7F},
	{0,0x0E80},	{1,0x0E81},	{1,0x0E82},	{0,0x0E83},
	{1,0x0E84},	{0,0x0E85},	{0,0x0E86},	{1,0x0E87},
	{1,0x0E88},	{0,0x0E89},	{1,0x0E8A},	{0,0x0E8B},
	{0,0x0E8C},	{1,0x0E8D},	{0,0x0E8E},	{0,0x0E8F},
	{0,0x0E90},	{0,0x0E91},	{0,0x0E92},	{0,0x0E93},
	{1,0x0E94},	{1,0x0E95},	{1,0x0E96},	{1,0x0E97},
	{0,0x0E98},	{1,0x0E99},	{1,0x0E9A},	{1,0x0E9B},
	{1,0x0E9C},	{1,0x0E9D},	{1,0x0E9E},	{1,0x0E9F},
	{0,0x0EA0},	{1,0x0EA1},	{1,0x0EA2},	{1,0x0EA3},
	{0,0x0EA4},	{1,0x0EA5},	{0,0x0EA6},	{1,0x0EA7},
	{0,0x0EA8},	{0,0x0EA9},	{1,0x0EAA},	{1,0x0EAB},
	{0,0x0EAC},	{1,0x0EAD},	{1,0x0EAE},	{1,0x0EAF},
	{1,0x0EB0},	{1,0x0EB1},	{1,0x0EB2},	{1,0x0EB3},
	{1,0x0EB4},	{1,0x0EB5},	{1,0x0EB6},	{1,0x0EB7},
	{1,0x0EB8},	{1,0x0EB9},	{0,0x0EBA},	{1,0x0EBB},
	{1,0x0EBC},	{1,0x0EBD},	{0,0x0EBE},	{0,0x0EBF},
	{1,0x0EC0},	{1,0x0EC1},	{1,0x0EC2},	{1,0x0EC3},
	{1,0x0EC4},	{0,0x0EC5},	{1,0x0EC6},	{0,0x0EC7},
	{1,0x0EC8},	{1,0x0EC9},	{1,0x0ECA},	{1,0x0ECB},
	{1,0x0ECC},	{1,0x0ECD},	{0,0x0ECE},	{0,0x0ECF},
	{2,0x0ED0},	{2,0x0ED1},	{2,0x0ED2},	{2,0x0ED3},
	{2,0x0ED4},	{2,0x0ED5},	{2,0x0ED6},	{2,0x0ED7},
	{2,0x0ED8},	{2,0x0ED9},	{0,0x0EDA},	{0,0x0EDB},
	{1,0x0EDC},	{1,0x0EDD},	{0,0x0EDE},	{0,0x0EDF},
	{0,0x0EE0},	{0,0x0EE1},	{0,0x0EE2},	{0,0x0EE3},
	{0,0x0EE4},	{0,0x0EE5},	{0,0x0EE6},	{0,0x0EE7},
	{0,0x0EE8},	{0,0x0EE9},	{0,0x0EEA},	{0,0x0EEB},
	{0,0x0EEC},	{0,0x0EED},	{0,0x0EEE},	{0,0x0EEF},
	{0,0x0EF0},	{0,0x0EF1},	{0,0x0EF2},	{0,0x0EF3},
	{0,0x0EF4},	{0,0x0EF5},	{0,0x0EF6},	{0,0x0EF7},
	{0,0x0EF8},	{0,0x0EF9},	{0,0x0EFA},	{0,0x0EFB},
	{0,0x0EFC},	{0,0x0EFD},	{0,0x0EFE},	{0,0x0EFF},
{0,0}};

static UDM_UNICODE plane0F[257]={
	{1,0x0F00},	{0,0x0F01},	{0,0x0F02},	{0,0x0F03},
	{0,0x0F04},	{0,0x0F05},	{0,0x0F06},	{0,0x0F07},
	{0,0x0F08},	{0,0x0F09},	{0,0x0F0A},	{0,0x0F0B},
	{0,0x0F0C},	{0,0x0F0D},	{0,0x0F0E},	{0,0x0F0F},
	{0,0x0F10},	{0,0x0F11},	{0,0x0F12},	{0,0x0F13},
	{0,0x0F14},	{0,0x0F15},	{0,0x0F16},	{0,0x0F17},
	{1,0x0F18},	{1,0x0F19},	{0,0x0F1A},	{0,0x0F1B},
	{0,0x0F1C},	{0,0x0F1D},	{0,0x0F1E},	{0,0x0F1F},
	{2,0x0F20},	{2,0x0F21},	{2,0x0F22},	{2,0x0F23},
	{2,0x0F24},	{2,0x0F25},	{2,0x0F26},	{2,0x0F27},
	{2,0x0F28},	{2,0x0F29},	{0,0x0F2A},	{0,0x0F2B},
	{0,0x0F2C},	{0,0x0F2D},	{0,0x0F2E},	{0,0x0F2F},
	{0,0x0F30},	{0,0x0F31},	{0,0x0F32},	{0,0x0F33},
	{0,0x0F34},	{1,0x0F35},	{0,0x0F36},	{1,0x0F37},
	{0,0x0F38},	{1,0x0F39},	{0,0x0F3A},	{0,0x0F3B},
	{0,0x0F3C},	{0,0x0F3D},	{0,0x0F3E},	{0,0x0F3F},
	{1,0x0F40},	{1,0x0F41},	{1,0x0F42},	{1,0x0F43},
	{1,0x0F44},	{1,0x0F45},	{1,0x0F46},	{1,0x0F47},
	{0,0x0F48},	{1,0x0F49},	{1,0x0F4A},	{1,0x0F4B},
	{1,0x0F4C},	{1,0x0F4D},	{1,0x0F4E},	{1,0x0F4F},
	{1,0x0F50},	{1,0x0F51},	{1,0x0F52},	{1,0x0F53},
	{1,0x0F54},	{1,0x0F55},	{1,0x0F56},	{1,0x0F57},
	{1,0x0F58},	{1,0x0F59},	{1,0x0F5A},	{1,0x0F5B},
	{1,0x0F5C},	{1,0x0F5D},	{1,0x0F5E},	{1,0x0F5F},
	{1,0x0F60},	{1,0x0F61},	{1,0x0F62},	{1,0x0F63},
	{1,0x0F64},	{1,0x0F65},	{1,0x0F66},	{1,0x0F67},
	{1,0x0F68},	{1,0x0F69},	{1,0x0F6A},	{0,0x0F6B},
	{0,0x0F6C},	{0,0x0F6D},	{0,0x0F6E},	{0,0x0F6F},
	{0,0x0F70},	{1,0x0F71},	{1,0x0F72},	{1,0x0F73},
	{1,0x0F74},	{1,0x0F75},	{1,0x0F76},	{1,0x0F77},
	{1,0x0F78},	{1,0x0F79},	{1,0x0F7A},	{1,0x0F7B},
	{1,0x0F7C},	{1,0x0F7D},	{1,0x0F7E},	{0,0x0F7F},
	{1,0x0F80},	{1,0x0F81},	{1,0x0F82},	{1,0x0F83},
	{1,0x0F84},	{0,0x0F85},	{1,0x0F86},	{1,0x0F87},
	{1,0x0F88},	{1,0x0F89},	{1,0x0F8A},	{1,0x0F8B},
	{0,0x0F8C},	{0,0x0F8D},	{0,0x0F8E},	{0,0x0F8F},
	{1,0x0F90},	{1,0x0F91},	{1,0x0F92},	{1,0x0F93},
	{1,0x0F94},	{1,0x0F95},	{1,0x0F96},	{1,0x0F97},
	{0,0x0F98},	{1,0x0F99},	{1,0x0F9A},	{1,0x0F9B},
	{1,0x0F9C},	{1,0x0F9D},	{1,0x0F9E},	{1,0x0F9F},
	{1,0x0FA0},	{1,0x0FA1},	{1,0x0FA2},	{1,0x0FA3},
	{1,0x0FA4},	{1,0x0FA5},	{1,0x0FA6},	{1,0x0FA7},
	{1,0x0FA8},	{1,0x0FA9},	{1,0x0FAA},	{1,0x0FAB},
	{1,0x0FAC},	{1,0x0FAD},	{1,0x0FAE},	{1,0x0FAF},
	{1,0x0FB0},	{1,0x0FB1},	{1,0x0FB2},	{1,0x0FB3},
	{1,0x0FB4},	{1,0x0FB5},	{1,0x0FB6},	{1,0x0FB7},
	{1,0x0FB8},	{1,0x0FB9},	{1,0x0FBA},	{1,0x0FBB},
	{1,0x0FBC},	{0,0x0FBD},	{0,0x0FBE},	{0,0x0FBF},
	{0,0x0FC0},	{0,0x0FC1},	{0,0x0FC2},	{0,0x0FC3},
	{0,0x0FC4},	{0,0x0FC5},	{1,0x0FC6},	{0,0x0FC7},
	{0,0x0FC8},	{0,0x0FC9},	{0,0x0FCA},	{0,0x0FCB},
	{0,0x0FCC},	{0,0x0FCD},	{0,0x0FCE},	{0,0x0FCF},
	{0,0x0FD0},	{0,0x0FD1},	{0,0x0FD2},	{0,0x0FD3},
	{0,0x0FD4},	{0,0x0FD5},	{0,0x0FD6},	{0,0x0FD7},
	{0,0x0FD8},	{0,0x0FD9},	{0,0x0FDA},	{0,0x0FDB},
	{0,0x0FDC},	{0,0x0FDD},	{0,0x0FDE},	{0,0x0FDF},
	{0,0x0FE0},	{0,0x0FE1},	{0,0x0FE2},	{0,0x0FE3},
	{0,0x0FE4},	{0,0x0FE5},	{0,0x0FE6},	{0,0x0FE7},
	{0,0x0FE8},	{0,0x0FE9},	{0,0x0FEA},	{0,0x0FEB},
	{0,0x0FEC},	{0,0x0FED},	{0,0x0FEE},	{0,0x0FEF},
	{0,0x0FF0},	{0,0x0FF1},	{0,0x0FF2},	{0,0x0FF3},
	{0,0x0FF4},	{0,0x0FF5},	{0,0x0FF6},	{0,0x0FF7},
	{0,0x0FF8},	{0,0x0FF9},	{0,0x0FFA},	{0,0x0FFB},
	{0,0x0FFC},	{0,0x0FFD},	{0,0x0FFE},	{0,0x0FFF},
{0,0}};

static UDM_UNICODE plane10[257]={
	{1,0x1000},	{1,0x1001},	{1,0x1002},	{1,0x1003},
	{1,0x1004},	{1,0x1005},	{1,0x1006},	{1,0x1007},
	{1,0x1008},	{1,0x1009},	{1,0x100A},	{1,0x100B},
	{1,0x100C},	{1,0x100D},	{1,0x100E},	{1,0x100F},
	{1,0x1010},	{1,0x1011},	{1,0x1012},	{1,0x1013},
	{1,0x1014},	{1,0x1015},	{1,0x1016},	{1,0x1017},
	{1,0x1018},	{1,0x1019},	{1,0x101A},	{1,0x101B},
	{1,0x101C},	{1,0x101D},	{1,0x101E},	{1,0x101F},
	{1,0x1020},	{1,0x1021},	{0,0x1022},	{1,0x1023},
	{1,0x1024},	{1,0x1025},	{1,0x1026},	{1,0x1027},
	{0,0x1028},	{1,0x1029},	{1,0x102A},	{0,0x102B},
	{0,0x102C},	{1,0x102D},	{1,0x102E},	{1,0x102F},
	{1,0x1030},	{0,0x1031},	{1,0x1032},	{0,0x1033},
	{0,0x1034},	{0,0x1035},	{1,0x1036},	{1,0x1037},
	{0,0x1038},	{1,0x1039},	{0,0x103A},	{0,0x103B},
	{0,0x103C},	{0,0x103D},	{0,0x103E},	{0,0x103F},
	{2,0x1040},	{2,0x1041},	{2,0x1042},	{2,0x1043},
	{2,0x1044},	{2,0x1045},	{2,0x1046},	{2,0x1047},
	{2,0x1048},	{2,0x1049},	{0,0x104A},	{0,0x104B},
	{0,0x104C},	{0,0x104D},	{0,0x104E},	{0,0x104F},
	{1,0x1050},	{1,0x1051},	{1,0x1052},	{1,0x1053},
	{1,0x1054},	{1,0x1055},	{0,0x1056},	{0,0x1057},
	{1,0x1058},	{1,0x1059},	{0,0x105A},	{0,0x105B},
	{0,0x105C},	{0,0x105D},	{0,0x105E},	{0,0x105F},
	{0,0x1060},	{0,0x1061},	{0,0x1062},	{0,0x1063},
	{0,0x1064},	{0,0x1065},	{0,0x1066},	{0,0x1067},
	{0,0x1068},	{0,0x1069},	{0,0x106A},	{0,0x106B},
	{0,0x106C},	{0,0x106D},	{0,0x106E},	{0,0x106F},
	{0,0x1070},	{0,0x1071},	{0,0x1072},	{0,0x1073},
	{0,0x1074},	{0,0x1075},	{0,0x1076},	{0,0x1077},
	{0,0x1078},	{0,0x1079},	{0,0x107A},	{0,0x107B},
	{0,0x107C},	{0,0x107D},	{0,0x107E},	{0,0x107F},
	{0,0x1080},	{0,0x1081},	{0,0x1082},	{0,0x1083},
	{0,0x1084},	{0,0x1085},	{0,0x1086},	{0,0x1087},
	{0,0x1088},	{0,0x1089},	{0,0x108A},	{0,0x108B},
	{0,0x108C},	{0,0x108D},	{0,0x108E},	{0,0x108F},
	{0,0x1090},	{0,0x1091},	{0,0x1092},	{0,0x1093},
	{0,0x1094},	{0,0x1095},	{0,0x1096},	{0,0x1097},
	{0,0x1098},	{0,0x1099},	{0,0x109A},	{0,0x109B},
	{0,0x109C},	{0,0x109D},	{0,0x109E},	{0,0x109F},
	{1,0x10A0},	{1,0x10A1},	{1,0x10A2},	{1,0x10A3},
	{1,0x10A4},	{1,0x10A5},	{1,0x10A6},	{1,0x10A7},
	{1,0x10A8},	{1,0x10A9},	{1,0x10AA},	{1,0x10AB},
	{1,0x10AC},	{1,0x10AD},	{1,0x10AE},	{1,0x10AF},
	{1,0x10B0},	{1,0x10B1},	{1,0x10B2},	{1,0x10B3},
	{1,0x10B4},	{1,0x10B5},	{1,0x10B6},	{1,0x10B7},
	{1,0x10B8},	{1,0x10B9},	{1,0x10BA},	{1,0x10BB},
	{1,0x10BC},	{1,0x10BD},	{1,0x10BE},	{1,0x10BF},
	{1,0x10C0},	{1,0x10C1},	{1,0x10C2},	{1,0x10C3},
	{1,0x10C4},	{1,0x10C5},	{0,0x10C6},	{0,0x10C7},
	{0,0x10C8},	{0,0x10C9},	{0,0x10CA},	{0,0x10CB},
	{0,0x10CC},	{0,0x10CD},	{0,0x10CE},	{0,0x10CF},
	{1,0x10D0},	{1,0x10D1},	{1,0x10D2},	{1,0x10D3},
	{1,0x10D4},	{1,0x10D5},	{1,0x10D6},	{1,0x10D7},
	{1,0x10D8},	{1,0x10D9},	{1,0x10DA},	{1,0x10DB},
	{1,0x10DC},	{1,0x10DD},	{1,0x10DE},	{1,0x10DF},
	{1,0x10E0},	{1,0x10E1},	{1,0x10E2},	{1,0x10E3},
	{1,0x10E4},	{1,0x10E5},	{1,0x10E6},	{1,0x10E7},
	{1,0x10E8},	{1,0x10E9},	{1,0x10EA},	{1,0x10EB},
	{1,0x10EC},	{1,0x10ED},	{1,0x10EE},	{1,0x10EF},
	{1,0x10F0},	{1,0x10F1},	{1,0x10F2},	{1,0x10F3},
	{1,0x10F4},	{1,0x10F5},	{1,0x10F6},	{0,0x10F7},
	{0,0x10F8},	{0,0x10F9},	{0,0x10FA},	{0,0x10FB},
	{0,0x10FC},	{0,0x10FD},	{0,0x10FE},	{0,0x10FF},
{0,0}};

static UDM_UNICODE plane11[257]={
	{1,0x1100},	{1,0x1101},	{1,0x1102},	{1,0x1103},
	{1,0x1104},	{1,0x1105},	{1,0x1106},	{1,0x1107},
	{1,0x1108},	{1,0x1109},	{1,0x110A},	{1,0x110B},
	{1,0x110C},	{1,0x110D},	{1,0x110E},	{1,0x110F},
	{1,0x1110},	{1,0x1111},	{1,0x1112},	{1,0x1113},
	{1,0x1114},	{1,0x1115},	{1,0x1116},	{1,0x1117},
	{1,0x1118},	{1,0x1119},	{1,0x111A},	{1,0x111B},
	{1,0x111C},	{1,0x111D},	{1,0x111E},	{1,0x111F},
	{1,0x1120},	{1,0x1121},	{1,0x1122},	{1,0x1123},
	{1,0x1124},	{1,0x1125},	{1,0x1126},	{1,0x1127},
	{1,0x1128},	{1,0x1129},	{1,0x112A},	{1,0x112B},
	{1,0x112C},	{1,0x112D},	{1,0x112E},	{1,0x112F},
	{1,0x1130},	{1,0x1131},	{1,0x1132},	{1,0x1133},
	{1,0x1134},	{1,0x1135},	{1,0x1136},	{1,0x1137},
	{1,0x1138},	{1,0x1139},	{1,0x113A},	{1,0x113B},
	{1,0x113C},	{1,0x113D},	{1,0x113E},	{1,0x113F},
	{1,0x1140},	{1,0x1141},	{1,0x1142},	{1,0x1143},
	{1,0x1144},	{1,0x1145},	{1,0x1146},	{1,0x1147},
	{1,0x1148},	{1,0x1149},	{1,0x114A},	{1,0x114B},
	{1,0x114C},	{1,0x114D},	{1,0x114E},	{1,0x114F},
	{1,0x1150},	{1,0x1151},	{1,0x1152},	{1,0x1153},
	{1,0x1154},	{1,0x1155},	{1,0x1156},	{1,0x1157},
	{1,0x1158},	{1,0x1159},	{0,0x115A},	{0,0x115B},
	{0,0x115C},	{0,0x115D},	{0,0x115E},	{1,0x115F},
	{1,0x1160},	{1,0x1161},	{1,0x1162},	{1,0x1163},
	{1,0x1164},	{1,0x1165},	{1,0x1166},	{1,0x1167},
	{1,0x1168},	{1,0x1169},	{1,0x116A},	{1,0x116B},
	{1,0x116C},	{1,0x116D},	{1,0x116E},	{1,0x116F},
	{1,0x1170},	{1,0x1171},	{1,0x1172},	{1,0x1173},
	{1,0x1174},	{1,0x1175},	{1,0x1176},	{1,0x1177},
	{1,0x1178},	{1,0x1179},	{1,0x117A},	{1,0x117B},
	{1,0x117C},	{1,0x117D},	{1,0x117E},	{1,0x117F},
	{1,0x1180},	{1,0x1181},	{1,0x1182},	{1,0x1183},
	{1,0x1184},	{1,0x1185},	{1,0x1186},	{1,0x1187},
	{1,0x1188},	{1,0x1189},	{1,0x118A},	{1,0x118B},
	{1,0x118C},	{1,0x118D},	{1,0x118E},	{1,0x118F},
	{1,0x1190},	{1,0x1191},	{1,0x1192},	{1,0x1193},
	{1,0x1194},	{1,0x1195},	{1,0x1196},	{1,0x1197},
	{1,0x1198},	{1,0x1199},	{1,0x119A},	{1,0x119B},
	{1,0x119C},	{1,0x119D},	{1,0x119E},	{1,0x119F},
	{1,0x11A0},	{1,0x11A1},	{1,0x11A2},	{0,0x11A3},
	{0,0x11A4},	{0,0x11A5},	{0,0x11A6},	{0,0x11A7},
	{1,0x11A8},	{1,0x11A9},	{1,0x11AA},	{1,0x11AB},
	{1,0x11AC},	{1,0x11AD},	{1,0x11AE},	{1,0x11AF},
	{1,0x11B0},	{1,0x11B1},	{1,0x11B2},	{1,0x11B3},
	{1,0x11B4},	{1,0x11B5},	{1,0x11B6},	{1,0x11B7},
	{1,0x11B8},	{1,0x11B9},	{1,0x11BA},	{1,0x11BB},
	{1,0x11BC},	{1,0x11BD},	{1,0x11BE},	{1,0x11BF},
	{1,0x11C0},	{1,0x11C1},	{1,0x11C2},	{1,0x11C3},
	{1,0x11C4},	{1,0x11C5},	{1,0x11C6},	{1,0x11C7},
	{1,0x11C8},	{1,0x11C9},	{1,0x11CA},	{1,0x11CB},
	{1,0x11CC},	{1,0x11CD},	{1,0x11CE},	{1,0x11CF},
	{1,0x11D0},	{1,0x11D1},	{1,0x11D2},	{1,0x11D3},
	{1,0x11D4},	{1,0x11D5},	{1,0x11D6},	{1,0x11D7},
	{1,0x11D8},	{1,0x11D9},	{1,0x11DA},	{1,0x11DB},
	{1,0x11DC},	{1,0x11DD},	{1,0x11DE},	{1,0x11DF},
	{1,0x11E0},	{1,0x11E1},	{1,0x11E2},	{1,0x11E3},
	{1,0x11E4},	{1,0x11E5},	{1,0x11E6},	{1,0x11E7},
	{1,0x11E8},	{1,0x11E9},	{1,0x11EA},	{1,0x11EB},
	{1,0x11EC},	{1,0x11ED},	{1,0x11EE},	{1,0x11EF},
	{1,0x11F0},	{1,0x11F1},	{1,0x11F2},	{1,0x11F3},
	{1,0x11F4},	{1,0x11F5},	{1,0x11F6},	{1,0x11F7},
	{1,0x11F8},	{1,0x11F9},	{0,0x11FA},	{0,0x11FB},
	{0,0x11FC},	{0,0x11FD},	{0,0x11FE},	{0,0x11FF},
{0,0}};

static UDM_UNICODE plane12[257]={
	{1,0x1200},	{1,0x1201},	{1,0x1202},	{1,0x1203},
	{1,0x1204},	{1,0x1205},	{1,0x1206},	{0,0x1207},
	{1,0x1208},	{1,0x1209},	{1,0x120A},	{1,0x120B},
	{1,0x120C},	{1,0x120D},	{1,0x120E},	{1,0x120F},
	{1,0x1210},	{1,0x1211},	{1,0x1212},	{1,0x1213},
	{1,0x1214},	{1,0x1215},	{1,0x1216},	{1,0x1217},
	{1,0x1218},	{1,0x1219},	{1,0x121A},	{1,0x121B},
	{1,0x121C},	{1,0x121D},	{1,0x121E},	{1,0x121F},
	{1,0x1220},	{1,0x1221},	{1,0x1222},	{1,0x1223},
	{1,0x1224},	{1,0x1225},	{1,0x1226},	{1,0x1227},
	{1,0x1228},	{1,0x1229},	{1,0x122A},	{1,0x122B},
	{1,0x122C},	{1,0x122D},	{1,0x122E},	{1,0x122F},
	{1,0x1230},	{1,0x1231},	{1,0x1232},	{1,0x1233},
	{1,0x1234},	{1,0x1235},	{1,0x1236},	{1,0x1237},
	{1,0x1238},	{1,0x1239},	{1,0x123A},	{1,0x123B},
	{1,0x123C},	{1,0x123D},	{1,0x123E},	{1,0x123F},
	{1,0x1240},	{1,0x1241},	{1,0x1242},	{1,0x1243},
	{1,0x1244},	{1,0x1245},	{1,0x1246},	{0,0x1247},
	{1,0x1248},	{0,0x1249},	{1,0x124A},	{1,0x124B},
	{1,0x124C},	{1,0x124D},	{0,0x124E},	{0,0x124F},
	{1,0x1250},	{1,0x1251},	{1,0x1252},	{1,0x1253},
	{1,0x1254},	{1,0x1255},	{1,0x1256},	{0,0x1257},
	{1,0x1258},	{0,0x1259},	{1,0x125A},	{1,0x125B},
	{1,0x125C},	{1,0x125D},	{0,0x125E},	{0,0x125F},
	{1,0x1260},	{1,0x1261},	{1,0x1262},	{1,0x1263},
	{1,0x1264},	{1,0x1265},	{1,0x1266},	{1,0x1267},
	{1,0x1268},	{1,0x1269},	{1,0x126A},	{1,0x126B},
	{1,0x126C},	{1,0x126D},	{1,0x126E},	{1,0x126F},
	{1,0x1270},	{1,0x1271},	{1,0x1272},	{1,0x1273},
	{1,0x1274},	{1,0x1275},	{1,0x1276},	{1,0x1277},
	{1,0x1278},	{1,0x1279},	{1,0x127A},	{1,0x127B},
	{1,0x127C},	{1,0x127D},	{1,0x127E},	{1,0x127F},
	{1,0x1280},	{1,0x1281},	{1,0x1282},	{1,0x1283},
	{1,0x1284},	{1,0x1285},	{1,0x1286},	{0,0x1287},
	{1,0x1288},	{0,0x1289},	{1,0x128A},	{1,0x128B},
	{1,0x128C},	{1,0x128D},	{0,0x128E},	{0,0x128F},
	{1,0x1290},	{1,0x1291},	{1,0x1292},	{1,0x1293},
	{1,0x1294},	{1,0x1295},	{1,0x1296},	{1,0x1297},
	{1,0x1298},	{1,0x1299},	{1,0x129A},	{1,0x129B},
	{1,0x129C},	{1,0x129D},	{1,0x129E},	{1,0x129F},
	{1,0x12A0},	{1,0x12A1},	{1,0x12A2},	{1,0x12A3},
	{1,0x12A4},	{1,0x12A5},	{1,0x12A6},	{1,0x12A7},
	{1,0x12A8},	{1,0x12A9},	{1,0x12AA},	{1,0x12AB},
	{1,0x12AC},	{1,0x12AD},	{1,0x12AE},	{0,0x12AF},
	{1,0x12B0},	{0,0x12B1},	{1,0x12B2},	{1,0x12B3},
	{1,0x12B4},	{1,0x12B5},	{0,0x12B6},	{0,0x12B7},
	{1,0x12B8},	{1,0x12B9},	{1,0x12BA},	{1,0x12BB},
	{1,0x12BC},	{1,0x12BD},	{1,0x12BE},	{0,0x12BF},
	{1,0x12C0},	{0,0x12C1},	{1,0x12C2},	{1,0x12C3},
	{1,0x12C4},	{1,0x12C5},	{0,0x12C6},	{0,0x12C7},
	{1,0x12C8},	{1,0x12C9},	{1,0x12CA},	{1,0x12CB},
	{1,0x12CC},	{1,0x12CD},	{1,0x12CE},	{0,0x12CF},
	{1,0x12D0},	{1,0x12D1},	{1,0x12D2},	{1,0x12D3},
	{1,0x12D4},	{1,0x12D5},	{1,0x12D6},	{0,0x12D7},
	{1,0x12D8},	{1,0x12D9},	{1,0x12DA},	{1,0x12DB},
	{1,0x12DC},	{1,0x12DD},	{1,0x12DE},	{1,0x12DF},
	{1,0x12E0},	{1,0x12E1},	{1,0x12E2},	{1,0x12E3},
	{1,0x12E4},	{1,0x12E5},	{1,0x12E6},	{1,0x12E7},
	{1,0x12E8},	{1,0x12E9},	{1,0x12EA},	{1,0x12EB},
	{1,0x12EC},	{1,0x12ED},	{1,0x12EE},	{0,0x12EF},
	{1,0x12F0},	{1,0x12F1},	{1,0x12F2},	{1,0x12F3},
	{1,0x12F4},	{1,0x12F5},	{1,0x12F6},	{1,0x12F7},
	{1,0x12F8},	{1,0x12F9},	{1,0x12FA},	{1,0x12FB},
	{1,0x12FC},	{1,0x12FD},	{1,0x12FE},	{1,0x12FF},
{0,0}};

static UDM_UNICODE plane13[257]={
	{1,0x1300},	{1,0x1301},	{1,0x1302},	{1,0x1303},
	{1,0x1304},	{1,0x1305},	{1,0x1306},	{1,0x1307},
	{1,0x1308},	{1,0x1309},	{1,0x130A},	{1,0x130B},
	{1,0x130C},	{1,0x130D},	{1,0x130E},	{0,0x130F},
	{1,0x1310},	{0,0x1311},	{1,0x1312},	{1,0x1313},
	{1,0x1314},	{1,0x1315},	{0,0x1316},	{0,0x1317},
	{1,0x1318},	{1,0x1319},	{1,0x131A},	{1,0x131B},
	{1,0x131C},	{1,0x131D},	{1,0x131E},	{0,0x131F},
	{1,0x1320},	{1,0x1321},	{1,0x1322},	{1,0x1323},
	{1,0x1324},	{1,0x1325},	{1,0x1326},	{1,0x1327},
	{1,0x1328},	{1,0x1329},	{1,0x132A},	{1,0x132B},
	{1,0x132C},	{1,0x132D},	{1,0x132E},	{1,0x132F},
	{1,0x1330},	{1,0x1331},	{1,0x1332},	{1,0x1333},
	{1,0x1334},	{1,0x1335},	{1,0x1336},	{1,0x1337},
	{1,0x1338},	{1,0x1339},	{1,0x133A},	{1,0x133B},
	{1,0x133C},	{1,0x133D},	{1,0x133E},	{1,0x133F},
	{1,0x1340},	{1,0x1341},	{1,0x1342},	{1,0x1343},
	{1,0x1344},	{1,0x1345},	{1,0x1346},	{0,0x1347},
	{1,0x1348},	{1,0x1349},	{1,0x134A},	{1,0x134B},
	{1,0x134C},	{1,0x134D},	{1,0x134E},	{1,0x134F},
	{1,0x1350},	{1,0x1351},	{1,0x1352},	{1,0x1353},
	{1,0x1354},	{1,0x1355},	{1,0x1356},	{1,0x1357},
	{1,0x1358},	{1,0x1359},	{1,0x135A},	{0,0x135B},
	{0,0x135C},	{0,0x135D},	{0,0x135E},	{0,0x135F},
	{0,0x1360},	{0,0x1361},	{0,0x1362},	{0,0x1363},
	{0,0x1364},	{0,0x1365},	{0,0x1366},	{0,0x1367},
	{0,0x1368},	{2,0x1369},	{2,0x136A},	{2,0x136B},
	{2,0x136C},	{2,0x136D},	{2,0x136E},	{2,0x136F},
	{2,0x1370},	{2,0x1371},	{0,0x1372},	{0,0x1373},
	{0,0x1374},	{0,0x1375},	{0,0x1376},	{0,0x1377},
	{0,0x1378},	{0,0x1379},	{0,0x137A},	{0,0x137B},
	{0,0x137C},	{0,0x137D},	{0,0x137E},	{0,0x137F},
	{0,0x1380},	{0,0x1381},	{0,0x1382},	{0,0x1383},
	{0,0x1384},	{0,0x1385},	{0,0x1386},	{0,0x1387},
	{0,0x1388},	{0,0x1389},	{0,0x138A},	{0,0x138B},
	{0,0x138C},	{0,0x138D},	{0,0x138E},	{0,0x138F},
	{0,0x1390},	{0,0x1391},	{0,0x1392},	{0,0x1393},
	{0,0x1394},	{0,0x1395},	{0,0x1396},	{0,0x1397},
	{0,0x1398},	{0,0x1399},	{0,0x139A},	{0,0x139B},
	{0,0x139C},	{0,0x139D},	{0,0x139E},	{0,0x139F},
	{1,0x13A0},	{1,0x13A1},	{1,0x13A2},	{1,0x13A3},
	{1,0x13A4},	{1,0x13A5},	{1,0x13A6},	{1,0x13A7},
	{1,0x13A8},	{1,0x13A9},	{1,0x13AA},	{1,0x13AB},
	{1,0x13AC},	{1,0x13AD},	{1,0x13AE},	{1,0x13AF},
	{1,0x13B0},	{1,0x13B1},	{1,0x13B2},	{1,0x13B3},
	{1,0x13B4},	{1,0x13B5},	{1,0x13B6},	{1,0x13B7},
	{1,0x13B8},	{1,0x13B9},	{1,0x13BA},	{1,0x13BB},
	{1,0x13BC},	{1,0x13BD},	{1,0x13BE},	{1,0x13BF},
	{1,0x13C0},	{1,0x13C1},	{1,0x13C2},	{1,0x13C3},
	{1,0x13C4},	{1,0x13C5},	{1,0x13C6},	{1,0x13C7},
	{1,0x13C8},	{1,0x13C9},	{1,0x13CA},	{1,0x13CB},
	{1,0x13CC},	{1,0x13CD},	{1,0x13CE},	{1,0x13CF},
	{1,0x13D0},	{1,0x13D1},	{1,0x13D2},	{1,0x13D3},
	{1,0x13D4},	{1,0x13D5},	{1,0x13D6},	{1,0x13D7},
	{1,0x13D8},	{1,0x13D9},	{1,0x13DA},	{1,0x13DB},
	{1,0x13DC},	{1,0x13DD},	{1,0x13DE},	{1,0x13DF},
	{1,0x13E0},	{1,0x13E1},	{1,0x13E2},	{1,0x13E3},
	{1,0x13E4},	{1,0x13E5},	{1,0x13E6},	{1,0x13E7},
	{1,0x13E8},	{1,0x13E9},	{1,0x13EA},	{1,0x13EB},
	{1,0x13EC},	{1,0x13ED},	{1,0x13EE},	{1,0x13EF},
	{1,0x13F0},	{1,0x13F1},	{1,0x13F2},	{1,0x13F3},
	{1,0x13F4},	{0,0x13F5},	{0,0x13F6},	{0,0x13F7},
	{0,0x13F8},	{0,0x13F9},	{0,0x13FA},	{0,0x13FB},
	{0,0x13FC},	{0,0x13FD},	{0,0x13FE},	{0,0x13FF},
{0,0}};

static UDM_UNICODE plane14[257]={
	{0,0x1400},	{1,0x1401},	{1,0x1402},	{1,0x1403},
	{1,0x1404},	{1,0x1405},	{1,0x1406},	{1,0x1407},
	{1,0x1408},	{1,0x1409},	{1,0x140A},	{1,0x140B},
	{1,0x140C},	{1,0x140D},	{1,0x140E},	{1,0x140F},
	{1,0x1410},	{1,0x1411},	{1,0x1412},	{1,0x1413},
	{1,0x1414},	{1,0x1415},	{1,0x1416},	{1,0x1417},
	{1,0x1418},	{1,0x1419},	{1,0x141A},	{1,0x141B},
	{1,0x141C},	{1,0x141D},	{1,0x141E},	{1,0x141F},
	{1,0x1420},	{1,0x1421},	{1,0x1422},	{1,0x1423},
	{1,0x1424},	{1,0x1425},	{1,0x1426},	{1,0x1427},
	{1,0x1428},	{1,0x1429},	{1,0x142A},	{1,0x142B},
	{1,0x142C},	{1,0x142D},	{1,0x142E},	{1,0x142F},
	{1,0x1430},	{1,0x1431},	{1,0x1432},	{1,0x1433},
	{1,0x1434},	{1,0x1435},	{1,0x1436},	{1,0x1437},
	{1,0x1438},	{1,0x1439},	{1,0x143A},	{1,0x143B},
	{1,0x143C},	{1,0x143D},	{1,0x143E},	{1,0x143F},
	{1,0x1440},	{1,0x1441},	{1,0x1442},	{1,0x1443},
	{1,0x1444},	{1,0x1445},	{1,0x1446},	{1,0x1447},
	{1,0x1448},	{1,0x1449},	{1,0x144A},	{1,0x144B},
	{1,0x144C},	{1,0x144D},	{1,0x144E},	{1,0x144F},
	{1,0x1450},	{1,0x1451},	{1,0x1452},	{1,0x1453},
	{1,0x1454},	{1,0x1455},	{1,0x1456},	{1,0x1457},
	{1,0x1458},	{1,0x1459},	{1,0x145A},	{1,0x145B},
	{1,0x145C},	{1,0x145D},	{1,0x145E},	{1,0x145F},
	{1,0x1460},	{1,0x1461},	{1,0x1462},	{1,0x1463},
	{1,0x1464},	{1,0x1465},	{1,0x1466},	{1,0x1467},
	{1,0x1468},	{1,0x1469},	{1,0x146A},	{1,0x146B},
	{1,0x146C},	{1,0x146D},	{1,0x146E},	{1,0x146F},
	{1,0x1470},	{1,0x1471},	{1,0x1472},	{1,0x1473},
	{1,0x1474},	{1,0x1475},	{1,0x1476},	{1,0x1477},
	{1,0x1478},	{1,0x1479},	{1,0x147A},	{1,0x147B},
	{1,0x147C},	{1,0x147D},	{1,0x147E},	{1,0x147F},
	{1,0x1480},	{1,0x1481},	{1,0x1482},	{1,0x1483},
	{1,0x1484},	{1,0x1485},	{1,0x1486},	{1,0x1487},
	{1,0x1488},	{1,0x1489},	{1,0x148A},	{1,0x148B},
	{1,0x148C},	{1,0x148D},	{1,0x148E},	{1,0x148F},
	{1,0x1490},	{1,0x1491},	{1,0x1492},	{1,0x1493},
	{1,0x1494},	{1,0x1495},	{1,0x1496},	{1,0x1497},
	{1,0x1498},	{1,0x1499},	{1,0x149A},	{1,0x149B},
	{1,0x149C},	{1,0x149D},	{1,0x149E},	{1,0x149F},
	{1,0x14A0},	{1,0x14A1},	{1,0x14A2},	{1,0x14A3},
	{1,0x14A4},	{1,0x14A5},	{1,0x14A6},	{1,0x14A7},
	{1,0x14A8},	{1,0x14A9},	{1,0x14AA},	{1,0x14AB},
	{1,0x14AC},	{1,0x14AD},	{1,0x14AE},	{1,0x14AF},
	{1,0x14B0},	{1,0x14B1},	{1,0x14B2},	{1,0x14B3},
	{1,0x14B4},	{1,0x14B5},	{1,0x14B6},	{1,0x14B7},
	{1,0x14B8},	{1,0x14B9},	{1,0x14BA},	{1,0x14BB},
	{1,0x14BC},	{1,0x14BD},	{1,0x14BE},	{1,0x14BF},
	{1,0x14C0},	{1,0x14C1},	{1,0x14C2},	{1,0x14C3},
	{1,0x14C4},	{1,0x14C5},	{1,0x14C6},	{1,0x14C7},
	{1,0x14C8},	{1,0x14C9},	{1,0x14CA},	{1,0x14CB},
	{1,0x14CC},	{1,0x14CD},	{1,0x14CE},	{1,0x14CF},
	{1,0x14D0},	{1,0x14D1},	{1,0x14D2},	{1,0x14D3},
	{1,0x14D4},	{1,0x14D5},	{1,0x14D6},	{1,0x14D7},
	{1,0x14D8},	{1,0x14D9},	{1,0x14DA},	{1,0x14DB},
	{1,0x14DC},	{1,0x14DD},	{1,0x14DE},	{1,0x14DF},
	{1,0x14E0},	{1,0x14E1},	{1,0x14E2},	{1,0x14E3},
	{1,0x14E4},	{1,0x14E5},	{1,0x14E6},	{1,0x14E7},
	{1,0x14E8},	{1,0x14E9},	{1,0x14EA},	{1,0x14EB},
	{1,0x14EC},	{1,0x14ED},	{1,0x14EE},	{1,0x14EF},
	{1,0x14F0},	{1,0x14F1},	{1,0x14F2},	{1,0x14F3},
	{1,0x14F4},	{1,0x14F5},	{1,0x14F6},	{1,0x14F7},
	{1,0x14F8},	{1,0x14F9},	{1,0x14FA},	{1,0x14FB},
	{1,0x14FC},	{1,0x14FD},	{1,0x14FE},	{1,0x14FF},
{0,0}};

static UDM_UNICODE plane16[257]={
	{1,0x1600},	{1,0x1601},	{1,0x1602},	{1,0x1603},
	{1,0x1604},	{1,0x1605},	{1,0x1606},	{1,0x1607},
	{1,0x1608},	{1,0x1609},	{1,0x160A},	{1,0x160B},
	{1,0x160C},	{1,0x160D},	{1,0x160E},	{1,0x160F},
	{1,0x1610},	{1,0x1611},	{1,0x1612},	{1,0x1613},
	{1,0x1614},	{1,0x1615},	{1,0x1616},	{1,0x1617},
	{1,0x1618},	{1,0x1619},	{1,0x161A},	{1,0x161B},
	{1,0x161C},	{1,0x161D},	{1,0x161E},	{1,0x161F},
	{1,0x1620},	{1,0x1621},	{1,0x1622},	{1,0x1623},
	{1,0x1624},	{1,0x1625},	{1,0x1626},	{1,0x1627},
	{1,0x1628},	{1,0x1629},	{1,0x162A},	{1,0x162B},
	{1,0x162C},	{1,0x162D},	{1,0x162E},	{1,0x162F},
	{1,0x1630},	{1,0x1631},	{1,0x1632},	{1,0x1633},
	{1,0x1634},	{1,0x1635},	{1,0x1636},	{1,0x1637},
	{1,0x1638},	{1,0x1639},	{1,0x163A},	{1,0x163B},
	{1,0x163C},	{1,0x163D},	{1,0x163E},	{1,0x163F},
	{1,0x1640},	{1,0x1641},	{1,0x1642},	{1,0x1643},
	{1,0x1644},	{1,0x1645},	{1,0x1646},	{1,0x1647},
	{1,0x1648},	{1,0x1649},	{1,0x164A},	{1,0x164B},
	{1,0x164C},	{1,0x164D},	{1,0x164E},	{1,0x164F},
	{1,0x1650},	{1,0x1651},	{1,0x1652},	{1,0x1653},
	{1,0x1654},	{1,0x1655},	{1,0x1656},	{1,0x1657},
	{1,0x1658},	{1,0x1659},	{1,0x165A},	{1,0x165B},
	{1,0x165C},	{1,0x165D},	{1,0x165E},	{1,0x165F},
	{1,0x1660},	{1,0x1661},	{1,0x1662},	{1,0x1663},
	{1,0x1664},	{1,0x1665},	{1,0x1666},	{1,0x1667},
	{1,0x1668},	{1,0x1669},	{1,0x166A},	{1,0x166B},
	{1,0x166C},	{0,0x166D},	{0,0x166E},	{1,0x166F},
	{1,0x1670},	{1,0x1671},	{1,0x1672},	{1,0x1673},
	{1,0x1674},	{1,0x1675},	{1,0x1676},	{0,0x1677},
	{0,0x1678},	{0,0x1679},	{0,0x167A},	{0,0x167B},
	{0,0x167C},	{0,0x167D},	{0,0x167E},	{0,0x167F},
	{0,0x1680},	{1,0x1681},	{1,0x1682},	{1,0x1683},
	{1,0x1684},	{1,0x1685},	{1,0x1686},	{1,0x1687},
	{1,0x1688},	{1,0x1689},	{1,0x168A},	{1,0x168B},
	{1,0x168C},	{1,0x168D},	{1,0x168E},	{1,0x168F},
	{1,0x1690},	{1,0x1691},	{1,0x1692},	{1,0x1693},
	{1,0x1694},	{1,0x1695},	{1,0x1696},	{1,0x1697},
	{1,0x1698},	{1,0x1699},	{1,0x169A},	{0,0x169B},
	{0,0x169C},	{0,0x169D},	{0,0x169E},	{0,0x169F},
	{1,0x16A0},	{1,0x16A1},	{1,0x16A2},	{1,0x16A3},
	{1,0x16A4},	{1,0x16A5},	{1,0x16A6},	{1,0x16A7},
	{1,0x16A8},	{1,0x16A9},	{1,0x16AA},	{1,0x16AB},
	{1,0x16AC},	{1,0x16AD},	{1,0x16AE},	{1,0x16AF},
	{1,0x16B0},	{1,0x16B1},	{1,0x16B2},	{1,0x16B3},
	{1,0x16B4},	{1,0x16B5},	{1,0x16B6},	{1,0x16B7},
	{1,0x16B8},	{1,0x16B9},	{1,0x16BA},	{1,0x16BB},
	{1,0x16BC},	{1,0x16BD},	{1,0x16BE},	{1,0x16BF},
	{1,0x16C0},	{1,0x16C1},	{1,0x16C2},	{1,0x16C3},
	{1,0x16C4},	{1,0x16C5},	{1,0x16C6},	{1,0x16C7},
	{1,0x16C8},	{1,0x16C9},	{1,0x16CA},	{1,0x16CB},
	{1,0x16CC},	{1,0x16CD},	{1,0x16CE},	{1,0x16CF},
	{1,0x16D0},	{1,0x16D1},	{1,0x16D2},	{1,0x16D3},
	{1,0x16D4},	{1,0x16D5},	{1,0x16D6},	{1,0x16D7},
	{1,0x16D8},	{1,0x16D9},	{1,0x16DA},	{1,0x16DB},
	{1,0x16DC},	{1,0x16DD},	{1,0x16DE},	{1,0x16DF},
	{1,0x16E0},	{1,0x16E1},	{1,0x16E2},	{1,0x16E3},
	{1,0x16E4},	{1,0x16E5},	{1,0x16E6},	{1,0x16E7},
	{1,0x16E8},	{1,0x16E9},	{1,0x16EA},	{0,0x16EB},
	{0,0x16EC},	{0,0x16ED},	{0,0x16EE},	{0,0x16EF},
	{0,0x16F0},	{0,0x16F1},	{0,0x16F2},	{0,0x16F3},
	{0,0x16F4},	{0,0x16F5},	{0,0x16F6},	{0,0x16F7},
	{0,0x16F8},	{0,0x16F9},	{0,0x16FA},	{0,0x16FB},
	{0,0x16FC},	{0,0x16FD},	{0,0x16FE},	{0,0x16FF},
{0,0}};

static UDM_UNICODE plane17[257]={
	{0,0x1700},	{0,0x1701},	{0,0x1702},	{0,0x1703},
	{0,0x1704},	{0,0x1705},	{0,0x1706},	{0,0x1707},
	{0,0x1708},	{0,0x1709},	{0,0x170A},	{0,0x170B},
	{0,0x170C},	{0,0x170D},	{0,0x170E},	{0,0x170F},
	{0,0x1710},	{0,0x1711},	{0,0x1712},	{0,0x1713},
	{0,0x1714},	{0,0x1715},	{0,0x1716},	{0,0x1717},
	{0,0x1718},	{0,0x1719},	{0,0x171A},	{0,0x171B},
	{0,0x171C},	{0,0x171D},	{0,0x171E},	{0,0x171F},
	{0,0x1720},	{0,0x1721},	{0,0x1722},	{0,0x1723},
	{0,0x1724},	{0,0x1725},	{0,0x1726},	{0,0x1727},
	{0,0x1728},	{0,0x1729},	{0,0x172A},	{0,0x172B},
	{0,0x172C},	{0,0x172D},	{0,0x172E},	{0,0x172F},
	{0,0x1730},	{0,0x1731},	{0,0x1732},	{0,0x1733},
	{0,0x1734},	{0,0x1735},	{0,0x1736},	{0,0x1737},
	{0,0x1738},	{0,0x1739},	{0,0x173A},	{0,0x173B},
	{0,0x173C},	{0,0x173D},	{0,0x173E},	{0,0x173F},
	{0,0x1740},	{0,0x1741},	{0,0x1742},	{0,0x1743},
	{0,0x1744},	{0,0x1745},	{0,0x1746},	{0,0x1747},
	{0,0x1748},	{0,0x1749},	{0,0x174A},	{0,0x174B},
	{0,0x174C},	{0,0x174D},	{0,0x174E},	{0,0x174F},
	{0,0x1750},	{0,0x1751},	{0,0x1752},	{0,0x1753},
	{0,0x1754},	{0,0x1755},	{0,0x1756},	{0,0x1757},
	{0,0x1758},	{0,0x1759},	{0,0x175A},	{0,0x175B},
	{0,0x175C},	{0,0x175D},	{0,0x175E},	{0,0x175F},
	{0,0x1760},	{0,0x1761},	{0,0x1762},	{0,0x1763},
	{0,0x1764},	{0,0x1765},	{0,0x1766},	{0,0x1767},
	{0,0x1768},	{0,0x1769},	{0,0x176A},	{0,0x176B},
	{0,0x176C},	{0,0x176D},	{0,0x176E},	{0,0x176F},
	{0,0x1770},	{0,0x1771},	{0,0x1772},	{0,0x1773},
	{0,0x1774},	{0,0x1775},	{0,0x1776},	{0,0x1777},
	{0,0x1778},	{0,0x1779},	{0,0x177A},	{0,0x177B},
	{0,0x177C},	{0,0x177D},	{0,0x177E},	{0,0x177F},
	{1,0x1780},	{1,0x1781},	{1,0x1782},	{1,0x1783},
	{1,0x1784},	{1,0x1785},	{1,0x1786},	{1,0x1787},
	{1,0x1788},	{1,0x1789},	{1,0x178A},	{1,0x178B},
	{1,0x178C},	{1,0x178D},	{1,0x178E},	{1,0x178F},
	{1,0x1790},	{1,0x1791},	{1,0x1792},	{1,0x1793},
	{1,0x1794},	{1,0x1795},	{1,0x1796},	{1,0x1797},
	{1,0x1798},	{1,0x1799},	{1,0x179A},	{1,0x179B},
	{1,0x179C},	{1,0x179D},	{1,0x179E},	{1,0x179F},
	{1,0x17A0},	{1,0x17A1},	{1,0x17A2},	{1,0x17A3},
	{1,0x17A4},	{1,0x17A5},	{1,0x17A6},	{1,0x17A7},
	{1,0x17A8},	{1,0x17A9},	{1,0x17AA},	{1,0x17AB},
	{1,0x17AC},	{1,0x17AD},	{1,0x17AE},	{1,0x17AF},
	{1,0x17B0},	{1,0x17B1},	{1,0x17B2},	{1,0x17B3},
	{0,0x17B4},	{0,0x17B5},	{0,0x17B6},	{1,0x17B7},
	{1,0x17B8},	{1,0x17B9},	{1,0x17BA},	{1,0x17BB},
	{1,0x17BC},	{1,0x17BD},	{0,0x17BE},	{0,0x17BF},
	{0,0x17C0},	{0,0x17C1},	{0,0x17C2},	{0,0x17C3},
	{0,0x17C4},	{0,0x17C5},	{1,0x17C6},	{0,0x17C7},
	{0,0x17C8},	{1,0x17C9},	{1,0x17CA},	{1,0x17CB},
	{1,0x17CC},	{1,0x17CD},	{1,0x17CE},	{1,0x17CF},
	{1,0x17D0},	{1,0x17D1},	{1,0x17D2},	{1,0x17D3},
	{0,0x17D4},	{0,0x17D5},	{0,0x17D6},	{0,0x17D7},
	{0,0x17D8},	{0,0x17D9},	{0,0x17DA},	{0,0x17DB},
	{0,0x17DC},	{0,0x17DD},	{0,0x17DE},	{0,0x17DF},
	{2,0x17E0},	{2,0x17E1},	{2,0x17E2},	{2,0x17E3},
	{2,0x17E4},	{2,0x17E5},	{2,0x17E6},	{2,0x17E7},
	{2,0x17E8},	{2,0x17E9},	{0,0x17EA},	{0,0x17EB},
	{0,0x17EC},	{0,0x17ED},	{0,0x17EE},	{0,0x17EF},
	{0,0x17F0},	{0,0x17F1},	{0,0x17F2},	{0,0x17F3},
	{0,0x17F4},	{0,0x17F5},	{0,0x17F6},	{0,0x17F7},
	{0,0x17F8},	{0,0x17F9},	{0,0x17FA},	{0,0x17FB},
	{0,0x17FC},	{0,0x17FD},	{0,0x17FE},	{0,0x17FF},
{0,0}};

static UDM_UNICODE plane18[257]={
	{0,0x1800},	{0,0x1801},	{0,0x1802},	{0,0x1803},
	{0,0x1804},	{0,0x1805},	{0,0x1806},	{0,0x1807},
	{0,0x1808},	{0,0x1809},	{0,0x180A},	{0,0x180B},
	{0,0x180C},	{0,0x180D},	{0,0x180E},	{0,0x180F},
	{2,0x1810},	{2,0x1811},	{2,0x1812},	{2,0x1813},
	{2,0x1814},	{2,0x1815},	{2,0x1816},	{2,0x1817},
	{2,0x1818},	{2,0x1819},	{0,0x181A},	{0,0x181B},
	{0,0x181C},	{0,0x181D},	{0,0x181E},	{0,0x181F},
	{1,0x1820},	{1,0x1821},	{1,0x1822},	{1,0x1823},
	{1,0x1824},	{1,0x1825},	{1,0x1826},	{1,0x1827},
	{1,0x1828},	{1,0x1829},	{1,0x182A},	{1,0x182B},
	{1,0x182C},	{1,0x182D},	{1,0x182E},	{1,0x182F},
	{1,0x1830},	{1,0x1831},	{1,0x1832},	{1,0x1833},
	{1,0x1834},	{1,0x1835},	{1,0x1836},	{1,0x1837},
	{1,0x1838},	{1,0x1839},	{1,0x183A},	{1,0x183B},
	{1,0x183C},	{1,0x183D},	{1,0x183E},	{1,0x183F},
	{1,0x1840},	{1,0x1841},	{1,0x1842},	{1,0x1843},
	{1,0x1844},	{1,0x1845},	{1,0x1846},	{1,0x1847},
	{1,0x1848},	{1,0x1849},	{1,0x184A},	{1,0x184B},
	{1,0x184C},	{1,0x184D},	{1,0x184E},	{1,0x184F},
	{1,0x1850},	{1,0x1851},	{1,0x1852},	{1,0x1853},
	{1,0x1854},	{1,0x1855},	{1,0x1856},	{1,0x1857},
	{1,0x1858},	{1,0x1859},	{1,0x185A},	{1,0x185B},
	{1,0x185C},	{1,0x185D},	{1,0x185E},	{1,0x185F},
	{1,0x1860},	{1,0x1861},	{1,0x1862},	{1,0x1863},
	{1,0x1864},	{1,0x1865},	{1,0x1866},	{1,0x1867},
	{1,0x1868},	{1,0x1869},	{1,0x186A},	{1,0x186B},
	{1,0x186C},	{1,0x186D},	{1,0x186E},	{1,0x186F},
	{1,0x1870},	{1,0x1871},	{1,0x1872},	{1,0x1873},
	{1,0x1874},	{1,0x1875},	{1,0x1876},	{1,0x1877},
	{0,0x1878},	{0,0x1879},	{0,0x187A},	{0,0x187B},
	{0,0x187C},	{0,0x187D},	{0,0x187E},	{0,0x187F},
	{1,0x1880},	{1,0x1881},	{1,0x1882},	{1,0x1883},
	{1,0x1884},	{1,0x1885},	{1,0x1886},	{1,0x1887},
	{1,0x1888},	{1,0x1889},	{1,0x188A},	{1,0x188B},
	{1,0x188C},	{1,0x188D},	{1,0x188E},	{1,0x188F},
	{1,0x1890},	{1,0x1891},	{1,0x1892},	{1,0x1893},
	{1,0x1894},	{1,0x1895},	{1,0x1896},	{1,0x1897},
	{1,0x1898},	{1,0x1899},	{1,0x189A},	{1,0x189B},
	{1,0x189C},	{1,0x189D},	{1,0x189E},	{1,0x189F},
	{1,0x18A0},	{1,0x18A1},	{1,0x18A2},	{1,0x18A3},
	{1,0x18A4},	{1,0x18A5},	{1,0x18A6},	{1,0x18A7},
	{1,0x18A8},	{1,0x18A9},	{0,0x18AA},	{0,0x18AB},
	{0,0x18AC},	{0,0x18AD},	{0,0x18AE},	{0,0x18AF},
	{0,0x18B0},	{0,0x18B1},	{0,0x18B2},	{0,0x18B3},
	{0,0x18B4},	{0,0x18B5},	{0,0x18B6},	{0,0x18B7},
	{0,0x18B8},	{0,0x18B9},	{0,0x18BA},	{0,0x18BB},
	{0,0x18BC},	{0,0x18BD},	{0,0x18BE},	{0,0x18BF},
	{0,0x18C0},	{0,0x18C1},	{0,0x18C2},	{0,0x18C3},
	{0,0x18C4},	{0,0x18C5},	{0,0x18C6},	{0,0x18C7},
	{0,0x18C8},	{0,0x18C9},	{0,0x18CA},	{0,0x18CB},
	{0,0x18CC},	{0,0x18CD},	{0,0x18CE},	{0,0x18CF},
	{0,0x18D0},	{0,0x18D1},	{0,0x18D2},	{0,0x18D3},
	{0,0x18D4},	{0,0x18D5},	{0,0x18D6},	{0,0x18D7},
	{0,0x18D8},	{0,0x18D9},	{0,0x18DA},	{0,0x18DB},
	{0,0x18DC},	{0,0x18DD},	{0,0x18DE},	{0,0x18DF},
	{0,0x18E0},	{0,0x18E1},	{0,0x18E2},	{0,0x18E3},
	{0,0x18E4},	{0,0x18E5},	{0,0x18E6},	{0,0x18E7},
	{0,0x18E8},	{0,0x18E9},	{0,0x18EA},	{0,0x18EB},
	{0,0x18EC},	{0,0x18ED},	{0,0x18EE},	{0,0x18EF},
	{0,0x18F0},	{0,0x18F1},	{0,0x18F2},	{0,0x18F3},
	{0,0x18F4},	{0,0x18F5},	{0,0x18F6},	{0,0x18F7},
	{0,0x18F8},	{0,0x18F9},	{0,0x18FA},	{0,0x18FB},
	{0,0x18FC},	{0,0x18FD},	{0,0x18FE},	{0,0x18FF},
{0,0}};

static UDM_UNICODE plane1E[257]={
	{1,0x1E01},	{1,0x1E01},	{1,0x1E03},	{1,0x1E03},
	{1,0x1E05},	{1,0x1E05},	{1,0x1E07},	{1,0x1E07},
	{1,0x1E09},	{1,0x1E09},	{1,0x1E0B},	{1,0x1E0B},
	{1,0x1E0D},	{1,0x1E0D},	{1,0x1E0F},	{1,0x1E0F},
	{1,0x1E11},	{1,0x1E11},	{1,0x1E13},	{1,0x1E13},
	{1,0x1E15},	{1,0x1E15},	{1,0x1E17},	{1,0x1E17},
	{1,0x1E19},	{1,0x1E19},	{1,0x1E1B},	{1,0x1E1B},
	{1,0x1E1D},	{1,0x1E1D},	{1,0x1E1F},	{1,0x1E1F},
	{1,0x1E21},	{1,0x1E21},	{1,0x1E23},	{1,0x1E23},
	{1,0x1E25},	{1,0x1E25},	{1,0x1E27},	{1,0x1E27},
	{1,0x1E29},	{1,0x1E29},	{1,0x1E2B},	{1,0x1E2B},
	{1,0x1E2D},	{1,0x1E2D},	{1,0x1E2F},	{1,0x1E2F},
	{1,0x1E31},	{1,0x1E31},	{1,0x1E33},	{1,0x1E33},
	{1,0x1E35},	{1,0x1E35},	{1,0x1E37},	{1,0x1E37},
	{1,0x1E39},	{1,0x1E39},	{1,0x1E3B},	{1,0x1E3B},
	{1,0x1E3D},	{1,0x1E3D},	{1,0x1E3F},	{1,0x1E3F},
	{1,0x1E41},	{1,0x1E41},	{1,0x1E43},	{1,0x1E43},
	{1,0x1E45},	{1,0x1E45},	{1,0x1E47},	{1,0x1E47},
	{1,0x1E49},	{1,0x1E49},	{1,0x1E4B},	{1,0x1E4B},
	{1,0x1E4D},	{1,0x1E4D},	{1,0x1E4F},	{1,0x1E4F},
	{1,0x1E51},	{1,0x1E51},	{1,0x1E53},	{1,0x1E53},
	{1,0x1E55},	{1,0x1E55},	{1,0x1E57},	{1,0x1E57},
	{1,0x1E59},	{1,0x1E59},	{1,0x1E5B},	{1,0x1E5B},
	{1,0x1E5D},	{1,0x1E5D},	{1,0x1E5F},	{1,0x1E5F},
	{1,0x1E61},	{1,0x1E61},	{1,0x1E63},	{1,0x1E63},
	{1,0x1E65},	{1,0x1E65},	{1,0x1E67},	{1,0x1E67},
	{1,0x1E69},	{1,0x1E69},	{1,0x1E6B},	{1,0x1E6B},
	{1,0x1E6D},	{1,0x1E6D},	{1,0x1E6F},	{1,0x1E6F},
	{1,0x1E71},	{1,0x1E71},	{1,0x1E73},	{1,0x1E73},
	{1,0x1E75},	{1,0x1E75},	{1,0x1E77},	{1,0x1E77},
	{1,0x1E79},	{1,0x1E79},	{1,0x1E7B},	{1,0x1E7B},
	{1,0x1E7D},	{1,0x1E7D},	{1,0x1E7F},	{1,0x1E7F},
	{1,0x1E81},	{1,0x1E81},	{1,0x1E83},	{1,0x1E83},
	{1,0x1E85},	{1,0x1E85},	{1,0x1E87},	{1,0x1E87},
	{1,0x1E89},	{1,0x1E89},	{1,0x1E8B},	{1,0x1E8B},
	{1,0x1E8D},	{1,0x1E8D},	{1,0x1E8F},	{1,0x1E8F},
	{1,0x1E91},	{1,0x1E91},	{1,0x1E93},	{1,0x1E93},
	{1,0x1E95},	{1,0x1E95},	{1,0x1E96},	{1,0x1E97},
	{1,0x1E98},	{1,0x1E99},	{1,0x1E9A},	{1,0x1E9B},
	{0,0x1E9C},	{0,0x1E9D},	{0,0x1E9E},	{0,0x1E9F},
	{1,0x1EA1},	{1,0x1EA1},	{1,0x1EA3},	{1,0x1EA3},
	{1,0x1EA5},	{1,0x1EA5},	{1,0x1EA7},	{1,0x1EA7},
	{1,0x1EA9},	{1,0x1EA9},	{1,0x1EAB},	{1,0x1EAB},
	{1,0x1EAD},	{1,0x1EAD},	{1,0x1EAF},	{1,0x1EAF},
	{1,0x1EB1},	{1,0x1EB1},	{1,0x1EB3},	{1,0x1EB3},
	{1,0x1EB5},	{1,0x1EB5},	{1,0x1EB7},	{1,0x1EB7},
	{1,0x1EB9},	{1,0x1EB9},	{1,0x1EBB},	{1,0x1EBB},
	{1,0x1EBD},	{1,0x1EBD},	{1,0x1EBF},	{1,0x1EBF},
	{1,0x1EC1},	{1,0x1EC1},	{1,0x1EC3},	{1,0x1EC3},
	{1,0x1EC5},	{1,0x1EC5},	{1,0x1EC7},	{1,0x1EC7},
	{1,0x1EC9},	{1,0x1EC9},	{1,0x1ECB},	{1,0x1ECB},
	{1,0x1ECD},	{1,0x1ECD},	{1,0x1ECF},	{1,0x1ECF},
	{1,0x1ED1},	{1,0x1ED1},	{1,0x1ED3},	{1,0x1ED3},
	{1,0x1ED5},	{1,0x1ED5},	{1,0x1ED7},	{1,0x1ED7},
	{1,0x1ED9},	{1,0x1ED9},	{1,0x1EDB},	{1,0x1EDB},
	{1,0x1EDD},	{1,0x1EDD},	{1,0x1EDF},	{1,0x1EDF},
	{1,0x1EE1},	{1,0x1EE1},	{1,0x1EE3},	{1,0x1EE3},
	{1,0x1EE5},	{1,0x1EE5},	{1,0x1EE7},	{1,0x1EE7},
	{1,0x1EE9},	{1,0x1EE9},	{1,0x1EEB},	{1,0x1EEB},
	{1,0x1EED},	{1,0x1EED},	{1,0x1EEF},	{1,0x1EEF},
	{1,0x1EF1},	{1,0x1EF1},	{1,0x1EF3},	{1,0x1EF3},
	{1,0x1EF5},	{1,0x1EF5},	{1,0x1EF7},	{1,0x1EF7},
	{1,0x1EF9},	{1,0x1EF9},	{0,0x1EFA},	{0,0x1EFB},
	{0,0x1EFC},	{0,0x1EFD},	{0,0x1EFE},	{0,0x1EFF},
{0,0}};

static UDM_UNICODE plane1F[257]={
	{1,0x1F00},	{1,0x1F01},	{1,0x1F02},	{1,0x1F03},
	{1,0x1F04},	{1,0x1F05},	{1,0x1F06},	{1,0x1F07},
	{1,0x1F00},	{1,0x1F01},	{1,0x1F02},	{1,0x1F03},
	{1,0x1F04},	{1,0x1F05},	{1,0x1F06},	{1,0x1F07},
	{1,0x1F10},	{1,0x1F11},	{1,0x1F12},	{1,0x1F13},
	{1,0x1F14},	{1,0x1F15},	{0,0x1F16},	{0,0x1F17},
	{1,0x1F10},	{1,0x1F11},	{1,0x1F12},	{1,0x1F13},
	{1,0x1F14},	{1,0x1F15},	{0,0x1F1E},	{0,0x1F1F},
	{1,0x1F20},	{1,0x1F21},	{1,0x1F22},	{1,0x1F23},
	{1,0x1F24},	{1,0x1F25},	{1,0x1F26},	{1,0x1F27},
	{1,0x1F20},	{1,0x1F21},	{1,0x1F22},	{1,0x1F23},
	{1,0x1F24},	{1,0x1F25},	{1,0x1F26},	{1,0x1F27},
	{1,0x1F30},	{1,0x1F31},	{1,0x1F32},	{1,0x1F33},
	{1,0x1F34},	{1,0x1F35},	{1,0x1F36},	{1,0x1F37},
	{1,0x1F30},	{1,0x1F31},	{1,0x1F32},	{1,0x1F33},
	{1,0x1F34},	{1,0x1F35},	{1,0x1F36},	{1,0x1F37},
	{1,0x1F40},	{1,0x1F41},	{1,0x1F42},	{1,0x1F43},
	{1,0x1F44},	{1,0x1F45},	{0,0x1F46},	{0,0x1F47},
	{1,0x1F40},	{1,0x1F41},	{1,0x1F42},	{1,0x1F43},
	{1,0x1F44},	{1,0x1F45},	{0,0x1F4E},	{0,0x1F4F},
	{1,0x1F50},	{1,0x1F51},	{1,0x1F52},	{1,0x1F53},
	{1,0x1F54},	{1,0x1F55},	{1,0x1F56},	{1,0x1F57},
	{0,0x1F58},	{1,0x1F51},	{0,0x1F5A},	{1,0x1F53},
	{0,0x1F5C},	{1,0x1F55},	{0,0x1F5E},	{1,0x1F57},
	{1,0x1F60},	{1,0x1F61},	{1,0x1F62},	{1,0x1F63},
	{1,0x1F64},	{1,0x1F65},	{1,0x1F66},	{1,0x1F67},
	{1,0x1F60},	{1,0x1F61},	{1,0x1F62},	{1,0x1F63},
	{1,0x1F64},	{1,0x1F65},	{1,0x1F66},	{1,0x1F67},
	{1,0x1F70},	{1,0x1F71},	{1,0x1F72},	{1,0x1F73},
	{1,0x1F74},	{1,0x1F75},	{1,0x1F76},	{1,0x1F77},
	{1,0x1F78},	{1,0x1F79},	{1,0x1F7A},	{1,0x1F7B},
	{1,0x1F7C},	{1,0x1F7D},	{0,0x1F7E},	{0,0x1F7F},
	{1,0x1F80},	{1,0x1F81},	{1,0x1F82},	{1,0x1F83},
	{1,0x1F84},	{1,0x1F85},	{1,0x1F86},	{1,0x1F87},
	{0,0x1F80},	{0,0x1F81},	{0,0x1F82},	{0,0x1F83},
	{0,0x1F84},	{0,0x1F85},	{0,0x1F86},	{0,0x1F87},
	{1,0x1F90},	{1,0x1F91},	{1,0x1F92},	{1,0x1F93},
	{1,0x1F94},	{1,0x1F95},	{1,0x1F96},	{1,0x1F97},
	{0,0x1F90},	{0,0x1F91},	{0,0x1F92},	{0,0x1F93},
	{0,0x1F94},	{0,0x1F95},	{0,0x1F96},	{0,0x1F97},
	{1,0x1FA0},	{1,0x1FA1},	{1,0x1FA2},	{1,0x1FA3},
	{1,0x1FA4},	{1,0x1FA5},	{1,0x1FA6},	{1,0x1FA7},
	{0,0x1FA0},	{0,0x1FA1},	{0,0x1FA2},	{0,0x1FA3},
	{0,0x1FA4},	{0,0x1FA5},	{0,0x1FA6},	{0,0x1FA7},
	{1,0x1FB0},	{1,0x1FB1},	{1,0x1FB2},	{1,0x1FB3},
	{1,0x1FB4},	{0,0x1FB5},	{1,0x1FB6},	{1,0x1FB7},
	{1,0x1FB0},	{1,0x1FB1},	{1,0x1F70},	{1,0x1F71},
	{0,0x1FB3},	{0,0x1FBD},	{1,0x1FBE},	{0,0x1FBF},
	{0,0x1FC0},	{0,0x1FC1},	{1,0x1FC2},	{1,0x1FC3},
	{1,0x1FC4},	{0,0x1FC5},	{1,0x1FC6},	{1,0x1FC7},
	{1,0x1F72},	{1,0x1F73},	{1,0x1F74},	{1,0x1F75},
	{0,0x1FC3},	{0,0x1FCD},	{0,0x1FCE},	{0,0x1FCF},
	{1,0x1FD0},	{1,0x1FD1},	{1,0x1FD2},	{1,0x1FD3},
	{0,0x1FD4},	{0,0x1FD5},	{1,0x1FD6},	{1,0x1FD7},
	{1,0x1FD0},	{1,0x1FD1},	{1,0x1F76},	{1,0x1F77},
	{0,0x1FDC},	{0,0x1FDD},	{0,0x1FDE},	{0,0x1FDF},
	{1,0x1FE0},	{1,0x1FE1},	{1,0x1FE2},	{1,0x1FE3},
	{1,0x1FE4},	{1,0x1FE5},	{1,0x1FE6},	{1,0x1FE7},
	{1,0x1FE0},	{1,0x1FE1},	{1,0x1F7A},	{1,0x1F7B},
	{1,0x1FE5},	{0,0x1FED},	{0,0x1FEE},	{0,0x1FEF},
	{0,0x1FF0},	{0,0x1FF1},	{1,0x1FF2},	{1,0x1FF3},
	{1,0x1FF4},	{0,0x1FF5},	{1,0x1FF6},	{1,0x1FF7},
	{1,0x1F78},	{1,0x1F79},	{1,0x1F7C},	{1,0x1F7D},
	{0,0x1FF3},	{0,0x1FFD},	{0,0x1FFE},	{0,0x1FFF},
{0,0}};

static UDM_UNICODE plane20[257]={
	{0,0x2000},	{0,0x2001},	{0,0x2002},	{0,0x2003},
	{0,0x2004},	{0,0x2005},	{0,0x2006},	{0,0x2007},
	{0,0x2008},	{0,0x2009},	{0,0x200A},	{0,0x200B},
	{0,0x200C},	{0,0x200D},	{0,0x200E},	{0,0x200F},
	{0,0x2010},	{0,0x2011},	{0,0x2012},	{0,0x2013},
	{0,0x2014},	{0,0x2015},	{0,0x2016},	{0,0x2017},
	{0,0x2018},	{0,0x2019},	{0,0x201A},	{0,0x201B},
	{0,0x201C},	{0,0x201D},	{0,0x201E},	{0,0x201F},
	{0,0x2020},	{0,0x2021},	{0,0x2022},	{0,0x2023},
	{0,0x2024},	{0,0x2025},	{0,0x2026},	{0,0x2027},
	{0,0x2028},	{0,0x2029},	{0,0x202A},	{0,0x202B},
	{0,0x202C},	{0,0x202D},	{0,0x202E},	{0,0x202F},
	{0,0x2030},	{0,0x2031},	{0,0x2032},	{0,0x2033},
	{0,0x2034},	{0,0x2035},	{0,0x2036},	{0,0x2037},
	{0,0x2038},	{0,0x2039},	{0,0x203A},	{0,0x203B},
	{0,0x203C},	{0,0x203D},	{0,0x203E},	{0,0x203F},
	{0,0x2040},	{0,0x2041},	{0,0x2042},	{0,0x2043},
	{0,0x2044},	{0,0x2045},	{0,0x2046},	{0,0x2047},
	{0,0x2048},	{0,0x2049},	{0,0x204A},	{0,0x204B},
	{0,0x204C},	{0,0x204D},	{0,0x204E},	{0,0x204F},
	{0,0x2050},	{0,0x2051},	{0,0x2052},	{0,0x2053},
	{0,0x2054},	{0,0x2055},	{0,0x2056},	{0,0x2057},
	{0,0x2058},	{0,0x2059},	{0,0x205A},	{0,0x205B},
	{0,0x205C},	{0,0x205D},	{0,0x205E},	{0,0x205F},
	{0,0x2060},	{0,0x2061},	{0,0x2062},	{0,0x2063},
	{0,0x2064},	{0,0x2065},	{0,0x2066},	{0,0x2067},
	{0,0x2068},	{0,0x2069},	{0,0x206A},	{0,0x206B},
	{0,0x206C},	{0,0x206D},	{0,0x206E},	{0,0x206F},
	{0,0x2070},	{0,0x2071},	{0,0x2072},	{0,0x2073},
	{0,0x2074},	{0,0x2075},	{0,0x2076},	{0,0x2077},
	{0,0x2078},	{0,0x2079},	{0,0x207A},	{0,0x207B},
	{0,0x207C},	{0,0x207D},	{0,0x207E},	{1,0x207F},
	{0,0x2080},	{0,0x2081},	{0,0x2082},	{0,0x2083},
	{0,0x2084},	{0,0x2085},	{0,0x2086},	{0,0x2087},
	{0,0x2088},	{0,0x2089},	{0,0x208A},	{0,0x208B},
	{0,0x208C},	{0,0x208D},	{0,0x208E},	{0,0x208F},
	{0,0x2090},	{0,0x2091},	{0,0x2092},	{0,0x2093},
	{0,0x2094},	{0,0x2095},	{0,0x2096},	{0,0x2097},
	{0,0x2098},	{0,0x2099},	{0,0x209A},	{0,0x209B},
	{0,0x209C},	{0,0x209D},	{0,0x209E},	{0,0x209F},
	{0,0x20A0},	{0,0x20A1},	{0,0x20A2},	{0,0x20A3},
	{0,0x20A4},	{0,0x20A5},	{0,0x20A6},	{0,0x20A7},
	{0,0x20A8},	{0,0x20A9},	{0,0x20AA},	{0,0x20AB},
	{0,0x20AC},	{0,0x20AD},	{0,0x20AE},	{0,0x20AF},
	{0,0x20B0},	{0,0x20B1},	{0,0x20B2},	{0,0x20B3},
	{0,0x20B4},	{0,0x20B5},	{0,0x20B6},	{0,0x20B7},
	{0,0x20B8},	{0,0x20B9},	{0,0x20BA},	{0,0x20BB},
	{0,0x20BC},	{0,0x20BD},	{0,0x20BE},	{0,0x20BF},
	{0,0x20C0},	{0,0x20C1},	{0,0x20C2},	{0,0x20C3},
	{0,0x20C4},	{0,0x20C5},	{0,0x20C6},	{0,0x20C7},
	{0,0x20C8},	{0,0x20C9},	{0,0x20CA},	{0,0x20CB},
	{0,0x20CC},	{0,0x20CD},	{0,0x20CE},	{0,0x20CF},
	{1,0x20D0},	{1,0x20D1},	{1,0x20D2},	{1,0x20D3},
	{1,0x20D4},	{1,0x20D5},	{1,0x20D6},	{1,0x20D7},
	{1,0x20D8},	{1,0x20D9},	{1,0x20DA},	{1,0x20DB},
	{1,0x20DC},	{0,0x20DD},	{0,0x20DE},	{0,0x20DF},
	{0,0x20E0},	{1,0x20E1},	{0,0x20E2},	{0,0x20E3},
	{0,0x20E4},	{0,0x20E5},	{0,0x20E6},	{0,0x20E7},
	{0,0x20E8},	{0,0x20E9},	{0,0x20EA},	{0,0x20EB},
	{0,0x20EC},	{0,0x20ED},	{0,0x20EE},	{0,0x20EF},
	{0,0x20F0},	{0,0x20F1},	{0,0x20F2},	{0,0x20F3},
	{0,0x20F4},	{0,0x20F5},	{0,0x20F6},	{0,0x20F7},
	{0,0x20F8},	{0,0x20F9},	{0,0x20FA},	{0,0x20FB},
	{0,0x20FC},	{0,0x20FD},	{0,0x20FE},	{0,0x20FF},
{0,0}};

static UDM_UNICODE plane21[257]={
	{0,0x2100},	{0,0x2101},	{1,0x2102},	{0,0x2103},
	{0,0x2104},	{0,0x2105},	{0,0x2106},	{1,0x2107},
	{0,0x2108},	{0,0x2109},	{1,0x210A},	{1,0x210B},
	{1,0x210C},	{1,0x210D},	{1,0x210E},	{1,0x210F},
	{1,0x2110},	{1,0x2111},	{1,0x2112},	{1,0x2113},
	{0,0x2114},	{1,0x2115},	{0,0x2116},	{0,0x2117},
	{0,0x2118},	{1,0x2119},	{1,0x211A},	{1,0x211B},
	{1,0x211C},	{1,0x211D},	{0,0x211E},	{0,0x211F},
	{0,0x2120},	{0,0x2121},	{0,0x2122},	{0,0x2123},
	{1,0x2124},	{0,0x2125},	{1,0x03C9},	{0,0x2127},
	{1,0x2128},	{0,0x2129},	{1,0x006B},	{1,0x00E5},
	{1,0x212C},	{1,0x212D},	{0,0x212E},	{1,0x212F},
	{1,0x2130},	{1,0x2131},	{0,0x2132},	{1,0x2133},
	{1,0x2134},	{1,0x2135},	{1,0x2136},	{1,0x2137},
	{1,0x2138},	{1,0x2139},	{0,0x213A},	{0,0x213B},
	{0,0x213C},	{0,0x213D},	{0,0x213E},	{0,0x213F},
	{0,0x2140},	{0,0x2141},	{0,0x2142},	{0,0x2143},
	{0,0x2144},	{0,0x2145},	{0,0x2146},	{0,0x2147},
	{0,0x2148},	{0,0x2149},	{0,0x214A},	{0,0x214B},
	{0,0x214C},	{0,0x214D},	{0,0x214E},	{0,0x214F},
	{0,0x2150},	{0,0x2151},	{0,0x2152},	{0,0x2153},
	{0,0x2154},	{0,0x2155},	{0,0x2156},	{0,0x2157},
	{0,0x2158},	{0,0x2159},	{0,0x215A},	{0,0x215B},
	{0,0x215C},	{0,0x215D},	{0,0x215E},	{0,0x215F},
	{0,0x2170},	{0,0x2171},	{0,0x2172},	{0,0x2173},
	{0,0x2174},	{0,0x2175},	{0,0x2176},	{0,0x2177},
	{0,0x2178},	{0,0x2179},	{0,0x217A},	{0,0x217B},
	{0,0x217C},	{0,0x217D},	{0,0x217E},	{0,0x217F},
	{0,0x2170},	{0,0x2171},	{0,0x2172},	{0,0x2173},
	{0,0x2174},	{0,0x2175},	{0,0x2176},	{0,0x2177},
	{0,0x2178},	{0,0x2179},	{0,0x217A},	{0,0x217B},
	{0,0x217C},	{0,0x217D},	{0,0x217E},	{0,0x217F},
	{0,0x2180},	{0,0x2181},	{0,0x2182},	{0,0x2183},
	{0,0x2184},	{0,0x2185},	{0,0x2186},	{0,0x2187},
	{0,0x2188},	{0,0x2189},	{0,0x218A},	{0,0x218B},
	{0,0x218C},	{0,0x218D},	{0,0x218E},	{0,0x218F},
	{0,0x2190},	{0,0x2191},	{0,0x2192},	{0,0x2193},
	{0,0x2194},	{0,0x2195},	{0,0x2196},	{0,0x2197},
	{0,0x2198},	{0,0x2199},	{0,0x219A},	{0,0x219B},
	{0,0x219C},	{0,0x219D},	{0,0x219E},	{0,0x219F},
	{0,0x21A0},	{0,0x21A1},	{0,0x21A2},	{0,0x21A3},
	{0,0x21A4},	{0,0x21A5},	{0,0x21A6},	{0,0x21A7},
	{0,0x21A8},	{0,0x21A9},	{0,0x21AA},	{0,0x21AB},
	{0,0x21AC},	{0,0x21AD},	{0,0x21AE},	{0,0x21AF},
	{0,0x21B0},	{0,0x21B1},	{0,0x21B2},	{0,0x21B3},
	{0,0x21B4},	{0,0x21B5},	{0,0x21B6},	{0,0x21B7},
	{0,0x21B8},	{0,0x21B9},	{0,0x21BA},	{0,0x21BB},
	{0,0x21BC},	{0,0x21BD},	{0,0x21BE},	{0,0x21BF},
	{0,0x21C0},	{0,0x21C1},	{0,0x21C2},	{0,0x21C3},
	{0,0x21C4},	{0,0x21C5},	{0,0x21C6},	{0,0x21C7},
	{0,0x21C8},	{0,0x21C9},	{0,0x21CA},	{0,0x21CB},
	{0,0x21CC},	{0,0x21CD},	{0,0x21CE},	{0,0x21CF},
	{0,0x21D0},	{0,0x21D1},	{0,0x21D2},	{0,0x21D3},
	{0,0x21D4},	{0,0x21D5},	{0,0x21D6},	{0,0x21D7},
	{0,0x21D8},	{0,0x21D9},	{0,0x21DA},	{0,0x21DB},
	{0,0x21DC},	{0,0x21DD},	{0,0x21DE},	{0,0x21DF},
	{0,0x21E0},	{0,0x21E1},	{0,0x21E2},	{0,0x21E3},
	{0,0x21E4},	{0,0x21E5},	{0,0x21E6},	{0,0x21E7},
	{0,0x21E8},	{0,0x21E9},	{0,0x21EA},	{0,0x21EB},
	{0,0x21EC},	{0,0x21ED},	{0,0x21EE},	{0,0x21EF},
	{0,0x21F0},	{0,0x21F1},	{0,0x21F2},	{0,0x21F3},
	{0,0x21F4},	{0,0x21F5},	{0,0x21F6},	{0,0x21F7},
	{0,0x21F8},	{0,0x21F9},	{0,0x21FA},	{0,0x21FB},
	{0,0x21FC},	{0,0x21FD},	{0,0x21FE},	{0,0x21FF},
{0,0}};

static UDM_UNICODE plane24[257]={
	{0,0x2400},	{0,0x2401},	{0,0x2402},	{0,0x2403},
	{0,0x2404},	{0,0x2405},	{0,0x2406},	{0,0x2407},
	{0,0x2408},	{0,0x2409},	{0,0x240A},	{0,0x240B},
	{0,0x240C},	{0,0x240D},	{0,0x240E},	{0,0x240F},
	{0,0x2410},	{0,0x2411},	{0,0x2412},	{0,0x2413},
	{0,0x2414},	{0,0x2415},	{0,0x2416},	{0,0x2417},
	{0,0x2418},	{0,0x2419},	{0,0x241A},	{0,0x241B},
	{0,0x241C},	{0,0x241D},	{0,0x241E},	{0,0x241F},
	{0,0x2420},	{0,0x2421},	{0,0x2422},	{0,0x2423},
	{0,0x2424},	{0,0x2425},	{0,0x2426},	{0,0x2427},
	{0,0x2428},	{0,0x2429},	{0,0x242A},	{0,0x242B},
	{0,0x242C},	{0,0x242D},	{0,0x242E},	{0,0x242F},
	{0,0x2430},	{0,0x2431},	{0,0x2432},	{0,0x2433},
	{0,0x2434},	{0,0x2435},	{0,0x2436},	{0,0x2437},
	{0,0x2438},	{0,0x2439},	{0,0x243A},	{0,0x243B},
	{0,0x243C},	{0,0x243D},	{0,0x243E},	{0,0x243F},
	{0,0x2440},	{0,0x2441},	{0,0x2442},	{0,0x2443},
	{0,0x2444},	{0,0x2445},	{0,0x2446},	{0,0x2447},
	{0,0x2448},	{0,0x2449},	{0,0x244A},	{0,0x244B},
	{0,0x244C},	{0,0x244D},	{0,0x244E},	{0,0x244F},
	{0,0x2450},	{0,0x2451},	{0,0x2452},	{0,0x2453},
	{0,0x2454},	{0,0x2455},	{0,0x2456},	{0,0x2457},
	{0,0x2458},	{0,0x2459},	{0,0x245A},	{0,0x245B},
	{0,0x245C},	{0,0x245D},	{0,0x245E},	{0,0x245F},
	{0,0x2460},	{0,0x2461},	{0,0x2462},	{0,0x2463},
	{0,0x2464},	{0,0x2465},	{0,0x2466},	{0,0x2467},
	{0,0x2468},	{0,0x2469},	{0,0x246A},	{0,0x246B},
	{0,0x246C},	{0,0x246D},	{0,0x246E},	{0,0x246F},
	{0,0x2470},	{0,0x2471},	{0,0x2472},	{0,0x2473},
	{0,0x2474},	{0,0x2475},	{0,0x2476},	{0,0x2477},
	{0,0x2478},	{0,0x2479},	{0,0x247A},	{0,0x247B},
	{0,0x247C},	{0,0x247D},	{0,0x247E},	{0,0x247F},
	{0,0x2480},	{0,0x2481},	{0,0x2482},	{0,0x2483},
	{0,0x2484},	{0,0x2485},	{0,0x2486},	{0,0x2487},
	{0,0x2488},	{0,0x2489},	{0,0x248A},	{0,0x248B},
	{0,0x248C},	{0,0x248D},	{0,0x248E},	{0,0x248F},
	{0,0x2490},	{0,0x2491},	{0,0x2492},	{0,0x2493},
	{0,0x2494},	{0,0x2495},	{0,0x2496},	{0,0x2497},
	{0,0x2498},	{0,0x2499},	{0,0x249A},	{0,0x249B},
	{0,0x249C},	{0,0x249D},	{0,0x249E},	{0,0x249F},
	{0,0x24A0},	{0,0x24A1},	{0,0x24A2},	{0,0x24A3},
	{0,0x24A4},	{0,0x24A5},	{0,0x24A6},	{0,0x24A7},
	{0,0x24A8},	{0,0x24A9},	{0,0x24AA},	{0,0x24AB},
	{0,0x24AC},	{0,0x24AD},	{0,0x24AE},	{0,0x24AF},
	{0,0x24B0},	{0,0x24B1},	{0,0x24B2},	{0,0x24B3},
	{0,0x24B4},	{0,0x24B5},	{0,0x24D0},	{0,0x24D1},
	{0,0x24D2},	{0,0x24D3},	{0,0x24D4},	{0,0x24D5},
	{0,0x24D6},	{0,0x24D7},	{0,0x24D8},	{0,0x24D9},
	{0,0x24DA},	{0,0x24DB},	{0,0x24DC},	{0,0x24DD},
	{0,0x24DE},	{0,0x24DF},	{0,0x24E0},	{0,0x24E1},
	{0,0x24E2},	{0,0x24E3},	{0,0x24E4},	{0,0x24E5},
	{0,0x24E6},	{0,0x24E7},	{0,0x24E8},	{0,0x24E9},
	{0,0x24D0},	{0,0x24D1},	{0,0x24D2},	{0,0x24D3},
	{0,0x24D4},	{0,0x24D5},	{0,0x24D6},	{0,0x24D7},
	{0,0x24D8},	{0,0x24D9},	{0,0x24DA},	{0,0x24DB},
	{0,0x24DC},	{0,0x24DD},	{0,0x24DE},	{0,0x24DF},
	{0,0x24E0},	{0,0x24E1},	{0,0x24E2},	{0,0x24E3},
	{0,0x24E4},	{0,0x24E5},	{0,0x24E6},	{0,0x24E7},
	{0,0x24E8},	{0,0x24E9},	{0,0x24EA},	{0,0x24EB},
	{0,0x24EC},	{0,0x24ED},	{0,0x24EE},	{0,0x24EF},
	{0,0x24F0},	{0,0x24F1},	{0,0x24F2},	{0,0x24F3},
	{0,0x24F4},	{0,0x24F5},	{0,0x24F6},	{0,0x24F7},
	{0,0x24F8},	{0,0x24F9},	{0,0x24FA},	{0,0x24FB},
	{0,0x24FC},	{0,0x24FD},	{0,0x24FE},	{0,0x24FF},
{0,0}};

static UDM_UNICODE plane30[257]={
	{0,0x3000},	{0,0x3001},	{0,0x3002},	{0,0x3003},
	{0,0x3004},	{1,0x3005},	{1,0x3006},	{0,0x3007},
	{0,0x3008},	{0,0x3009},	{0,0x300A},	{0,0x300B},
	{0,0x300C},	{0,0x300D},	{0,0x300E},	{0,0x300F},
	{0,0x3010},	{0,0x3011},	{0,0x3012},	{0,0x3013},
	{0,0x3014},	{0,0x3015},	{0,0x3016},	{0,0x3017},
	{0,0x3018},	{0,0x3019},	{0,0x301A},	{0,0x301B},
	{0,0x301C},	{0,0x301D},	{0,0x301E},	{0,0x301F},
	{0,0x3020},	{0,0x3021},	{0,0x3022},	{0,0x3023},
	{0,0x3024},	{0,0x3025},	{0,0x3026},	{0,0x3027},
	{0,0x3028},	{0,0x3029},	{1,0x302A},	{1,0x302B},
	{1,0x302C},	{1,0x302D},	{1,0x302E},	{1,0x302F},
	{0,0x3030},	{1,0x3031},	{1,0x3032},	{1,0x3033},
	{1,0x3034},	{1,0x3035},	{0,0x3036},	{0,0x3037},
	{0,0x3038},	{0,0x3039},	{0,0x303A},	{0,0x303B},
	{0,0x303C},	{0,0x303D},	{0,0x303E},	{0,0x303F},
	{0,0x3040},	{1,0x3041},	{1,0x3042},	{1,0x3043},
	{1,0x3044},	{1,0x3045},	{1,0x3046},	{1,0x3047},
	{1,0x3048},	{1,0x3049},	{1,0x304A},	{1,0x304B},
	{1,0x304C},	{1,0x304D},	{1,0x304E},	{1,0x304F},
	{1,0x3050},	{1,0x3051},	{1,0x3052},	{1,0x3053},
	{1,0x3054},	{1,0x3055},	{1,0x3056},	{1,0x3057},
	{1,0x3058},	{1,0x3059},	{1,0x305A},	{1,0x305B},
	{1,0x305C},	{1,0x305D},	{1,0x305E},	{1,0x305F},
	{1,0x3060},	{1,0x3061},	{1,0x3062},	{1,0x3063},
	{1,0x3064},	{1,0x3065},	{1,0x3066},	{1,0x3067},
	{1,0x3068},	{1,0x3069},	{1,0x306A},	{1,0x306B},
	{1,0x306C},	{1,0x306D},	{1,0x306E},	{1,0x306F},
	{1,0x3070},	{1,0x3071},	{1,0x3072},	{1,0x3073},
	{1,0x3074},	{1,0x3075},	{1,0x3076},	{1,0x3077},
	{1,0x3078},	{1,0x3079},	{1,0x307A},	{1,0x307B},
	{1,0x307C},	{1,0x307D},	{1,0x307E},	{1,0x307F},
	{1,0x3080},	{1,0x3081},	{1,0x3082},	{1,0x3083},
	{1,0x3084},	{1,0x3085},	{1,0x3086},	{1,0x3087},
	{1,0x3088},	{1,0x3089},	{1,0x308A},	{1,0x308B},
	{1,0x308C},	{1,0x308D},	{1,0x308E},	{1,0x308F},
	{1,0x3090},	{1,0x3091},	{1,0x3092},	{1,0x3093},
	{1,0x3094},	{0,0x3095},	{0,0x3096},	{0,0x3097},
	{0,0x3098},	{1,0x3099},	{1,0x309A},	{0,0x309B},
	{0,0x309C},	{1,0x309D},	{1,0x309E},	{0,0x309F},
	{0,0x30A0},	{1,0x30A1},	{1,0x30A2},	{1,0x30A3},
	{1,0x30A4},	{1,0x30A5},	{1,0x30A6},	{1,0x30A7},
	{1,0x30A8},	{1,0x30A9},	{1,0x30AA},	{1,0x30AB},
	{1,0x30AC},	{1,0x30AD},	{1,0x30AE},	{1,0x30AF},
	{1,0x30B0},	{1,0x30B1},	{1,0x30B2},	{1,0x30B3},
	{1,0x30B4},	{1,0x30B5},	{1,0x30B6},	{1,0x30B7},
	{1,0x30B8},	{1,0x30B9},	{1,0x30BA},	{1,0x30BB},
	{1,0x30BC},	{1,0x30BD},	{1,0x30BE},	{1,0x30BF},
	{1,0x30C0},	{1,0x30C1},	{1,0x30C2},	{1,0x30C3},
	{1,0x30C4},	{1,0x30C5},	{1,0x30C6},	{1,0x30C7},
	{1,0x30C8},	{1,0x30C9},	{1,0x30CA},	{1,0x30CB},
	{1,0x30CC},	{1,0x30CD},	{1,0x30CE},	{1,0x30CF},
	{1,0x30D0},	{1,0x30D1},	{1,0x30D2},	{1,0x30D3},
	{1,0x30D4},	{1,0x30D5},	{1,0x30D6},	{1,0x30D7},
	{1,0x30D8},	{1,0x30D9},	{1,0x30DA},	{1,0x30DB},
	{1,0x30DC},	{1,0x30DD},	{1,0x30DE},	{1,0x30DF},
	{1,0x30E0},	{1,0x30E1},	{1,0x30E2},	{1,0x30E3},
	{1,0x30E4},	{1,0x30E5},	{1,0x30E6},	{1,0x30E7},
	{1,0x30E8},	{1,0x30E9},	{1,0x30EA},	{1,0x30EB},
	{1,0x30EC},	{1,0x30ED},	{1,0x30EE},	{1,0x30EF},
	{1,0x30F0},	{1,0x30F1},	{1,0x30F2},	{1,0x30F3},
	{1,0x30F4},	{1,0x30F5},	{1,0x30F6},	{1,0x30F7},
	{1,0x30F8},	{1,0x30F9},	{1,0x30FA},	{0,0x30FB},
	{1,0x30FC},	{1,0x30FD},	{1,0x30FE},	{0,0x30FF},
{0,0}};

static UDM_UNICODE plane31[257]={
	{0,0x3100},	{0,0x3101},	{0,0x3102},	{0,0x3103},
	{0,0x3104},	{1,0x3105},	{1,0x3106},	{1,0x3107},
	{1,0x3108},	{1,0x3109},	{1,0x310A},	{1,0x310B},
	{1,0x310C},	{1,0x310D},	{1,0x310E},	{1,0x310F},
	{1,0x3110},	{1,0x3111},	{1,0x3112},	{1,0x3113},
	{1,0x3114},	{1,0x3115},	{1,0x3116},	{1,0x3117},
	{1,0x3118},	{1,0x3119},	{1,0x311A},	{1,0x311B},
	{1,0x311C},	{1,0x311D},	{1,0x311E},	{1,0x311F},
	{1,0x3120},	{1,0x3121},	{1,0x3122},	{1,0x3123},
	{1,0x3124},	{1,0x3125},	{1,0x3126},	{1,0x3127},
	{1,0x3128},	{1,0x3129},	{1,0x312A},	{1,0x312B},
	{1,0x312C},	{0,0x312D},	{0,0x312E},	{0,0x312F},
	{0,0x3130},	{1,0x3131},	{1,0x3132},	{1,0x3133},
	{1,0x3134},	{1,0x3135},	{1,0x3136},	{1,0x3137},
	{1,0x3138},	{1,0x3139},	{1,0x313A},	{1,0x313B},
	{1,0x313C},	{1,0x313D},	{1,0x313E},	{1,0x313F},
	{1,0x3140},	{1,0x3141},	{1,0x3142},	{1,0x3143},
	{1,0x3144},	{1,0x3145},	{1,0x3146},	{1,0x3147},
	{1,0x3148},	{1,0x3149},	{1,0x314A},	{1,0x314B},
	{1,0x314C},	{1,0x314D},	{1,0x314E},	{1,0x314F},
	{1,0x3150},	{1,0x3151},	{1,0x3152},	{1,0x3153},
	{1,0x3154},	{1,0x3155},	{1,0x3156},	{1,0x3157},
	{1,0x3158},	{1,0x3159},	{1,0x315A},	{1,0x315B},
	{1,0x315C},	{1,0x315D},	{1,0x315E},	{1,0x315F},
	{1,0x3160},	{1,0x3161},	{1,0x3162},	{1,0x3163},
	{1,0x3164},	{1,0x3165},	{1,0x3166},	{1,0x3167},
	{1,0x3168},	{1,0x3169},	{1,0x316A},	{1,0x316B},
	{1,0x316C},	{1,0x316D},	{1,0x316E},	{1,0x316F},
	{1,0x3170},	{1,0x3171},	{1,0x3172},	{1,0x3173},
	{1,0x3174},	{1,0x3175},	{1,0x3176},	{1,0x3177},
	{1,0x3178},	{1,0x3179},	{1,0x317A},	{1,0x317B},
	{1,0x317C},	{1,0x317D},	{1,0x317E},	{1,0x317F},
	{1,0x3180},	{1,0x3181},	{1,0x3182},	{1,0x3183},
	{1,0x3184},	{1,0x3185},	{1,0x3186},	{1,0x3187},
	{1,0x3188},	{1,0x3189},	{1,0x318A},	{1,0x318B},
	{1,0x318C},	{1,0x318D},	{1,0x318E},	{0,0x318F},
	{0,0x3190},	{0,0x3191},	{0,0x3192},	{0,0x3193},
	{0,0x3194},	{0,0x3195},	{0,0x3196},	{0,0x3197},
	{0,0x3198},	{0,0x3199},	{0,0x319A},	{0,0x319B},
	{0,0x319C},	{0,0x319D},	{0,0x319E},	{0,0x319F},
	{1,0x31A0},	{1,0x31A1},	{1,0x31A2},	{1,0x31A3},
	{1,0x31A4},	{1,0x31A5},	{1,0x31A6},	{1,0x31A7},
	{1,0x31A8},	{1,0x31A9},	{1,0x31AA},	{1,0x31AB},
	{1,0x31AC},	{1,0x31AD},	{1,0x31AE},	{1,0x31AF},
	{1,0x31B0},	{1,0x31B1},	{1,0x31B2},	{1,0x31B3},
	{1,0x31B4},	{1,0x31B5},	{1,0x31B6},	{1,0x31B7},
	{0,0x31B8},	{0,0x31B9},	{0,0x31BA},	{0,0x31BB},
	{0,0x31BC},	{0,0x31BD},	{0,0x31BE},	{0,0x31BF},
	{0,0x31C0},	{0,0x31C1},	{0,0x31C2},	{0,0x31C3},
	{0,0x31C4},	{0,0x31C5},	{0,0x31C6},	{0,0x31C7},
	{0,0x31C8},	{0,0x31C9},	{0,0x31CA},	{0,0x31CB},
	{0,0x31CC},	{0,0x31CD},	{0,0x31CE},	{0,0x31CF},
	{0,0x31D0},	{0,0x31D1},	{0,0x31D2},	{0,0x31D3},
	{0,0x31D4},	{0,0x31D5},	{0,0x31D6},	{0,0x31D7},
	{0,0x31D8},	{0,0x31D9},	{0,0x31DA},	{0,0x31DB},
	{0,0x31DC},	{0,0x31DD},	{0,0x31DE},	{0,0x31DF},
	{0,0x31E0},	{0,0x31E1},	{0,0x31E2},	{0,0x31E3},
	{0,0x31E4},	{0,0x31E5},	{0,0x31E6},	{0,0x31E7},
	{0,0x31E8},	{0,0x31E9},	{0,0x31EA},	{0,0x31EB},
	{0,0x31EC},	{0,0x31ED},	{0,0x31EE},	{0,0x31EF},
	{0,0x31F0},	{0,0x31F1},	{0,0x31F2},	{0,0x31F3},
	{0,0x31F4},	{0,0x31F5},	{0,0x31F6},	{0,0x31F7},
	{0,0x31F8},	{0,0x31F9},	{0,0x31FA},	{0,0x31FB},
	{0,0x31FC},	{0,0x31FD},	{0,0x31FE},	{0,0x31FF},
{0,0}};

static UDM_UNICODE plane4D[257]={
	{3,0x4D00},	{3,0x4D01},	{3,0x4D02},	{3,0x4D03},
	{3,0x4D04},	{3,0x4D05},	{3,0x4D06},	{3,0x4D07},
	{3,0x4D08},	{3,0x4D09},	{3,0x4D0A},	{3,0x4D0B},
	{3,0x4D0C},	{3,0x4D0D},	{3,0x4D0E},	{3,0x4D0F},
	{3,0x4D10},	{3,0x4D11},	{3,0x4D12},	{3,0x4D13},
	{3,0x4D14},	{3,0x4D15},	{3,0x4D16},	{3,0x4D17},
	{3,0x4D18},	{3,0x4D19},	{3,0x4D1A},	{3,0x4D1B},
	{3,0x4D1C},	{3,0x4D1D},	{3,0x4D1E},	{3,0x4D1F},
	{3,0x4D20},	{3,0x4D21},	{3,0x4D22},	{3,0x4D23},
	{3,0x4D24},	{3,0x4D25},	{3,0x4D26},	{3,0x4D27},
	{3,0x4D28},	{3,0x4D29},	{3,0x4D2A},	{3,0x4D2B},
	{3,0x4D2C},	{3,0x4D2D},	{3,0x4D2E},	{3,0x4D2F},
	{3,0x4D30},	{3,0x4D31},	{3,0x4D32},	{3,0x4D33},
	{3,0x4D34},	{3,0x4D35},	{3,0x4D36},	{3,0x4D37},
	{3,0x4D38},	{3,0x4D39},	{3,0x4D3A},	{3,0x4D3B},
	{3,0x4D3C},	{3,0x4D3D},	{3,0x4D3E},	{3,0x4D3F},
	{3,0x4D40},	{3,0x4D41},	{3,0x4D42},	{3,0x4D43},
	{3,0x4D44},	{3,0x4D45},	{3,0x4D46},	{3,0x4D47},
	{3,0x4D48},	{3,0x4D49},	{3,0x4D4A},	{3,0x4D4B},
	{3,0x4D4C},	{3,0x4D4D},	{3,0x4D4E},	{3,0x4D4F},
	{3,0x4D50},	{3,0x4D51},	{3,0x4D52},	{3,0x4D53},
	{3,0x4D54},	{3,0x4D55},	{3,0x4D56},	{3,0x4D57},
	{3,0x4D58},	{3,0x4D59},	{3,0x4D5A},	{3,0x4D5B},
	{3,0x4D5C},	{3,0x4D5D},	{3,0x4D5E},	{3,0x4D5F},
	{3,0x4D60},	{3,0x4D61},	{3,0x4D62},	{3,0x4D63},
	{3,0x4D64},	{3,0x4D65},	{3,0x4D66},	{3,0x4D67},
	{3,0x4D68},	{3,0x4D69},	{3,0x4D6A},	{3,0x4D6B},
	{3,0x4D6C},	{3,0x4D6D},	{3,0x4D6E},	{3,0x4D6F},
	{3,0x4D70},	{3,0x4D71},	{3,0x4D72},	{3,0x4D73},
	{3,0x4D74},	{3,0x4D75},	{3,0x4D76},	{3,0x4D77},
	{3,0x4D78},	{3,0x4D79},	{3,0x4D7A},	{3,0x4D7B},
	{3,0x4D7C},	{3,0x4D7D},	{3,0x4D7E},	{3,0x4D7F},
	{3,0x4D80},	{3,0x4D81},	{3,0x4D82},	{3,0x4D83},
	{3,0x4D84},	{3,0x4D85},	{3,0x4D86},	{3,0x4D87},
	{3,0x4D88},	{3,0x4D89},	{3,0x4D8A},	{3,0x4D8B},
	{3,0x4D8C},	{3,0x4D8D},	{3,0x4D8E},	{3,0x4D8F},
	{3,0x4D90},	{3,0x4D91},	{3,0x4D92},	{3,0x4D93},
	{3,0x4D94},	{3,0x4D95},	{3,0x4D96},	{3,0x4D97},
	{3,0x4D98},	{3,0x4D99},	{3,0x4D9A},	{3,0x4D9B},
	{3,0x4D9C},	{3,0x4D9D},	{3,0x4D9E},	{3,0x4D9F},
	{3,0x4DA0},	{3,0x4DA1},	{3,0x4DA2},	{3,0x4DA3},
	{3,0x4DA4},	{3,0x4DA5},	{3,0x4DA6},	{3,0x4DA7},
	{3,0x4DA8},	{3,0x4DA9},	{3,0x4DAA},	{3,0x4DAB},
	{3,0x4DAC},	{3,0x4DAD},	{3,0x4DAE},	{3,0x4DAF},
	{3,0x4DB0},	{3,0x4DB1},	{3,0x4DB2},	{3,0x4DB3},
	{3,0x4DB4},	{3,0x4DB5},	{0,0x4DB6},	{0,0x4DB7},
	{0,0x4DB8},	{0,0x4DB9},	{0,0x4DBA},	{0,0x4DBB},
	{0,0x4DBC},	{0,0x4DBD},	{0,0x4DBE},	{0,0x4DBF},
	{0,0x4DC0},	{0,0x4DC1},	{0,0x4DC2},	{0,0x4DC3},
	{0,0x4DC4},	{0,0x4DC5},	{0,0x4DC6},	{0,0x4DC7},
	{0,0x4DC8},	{0,0x4DC9},	{0,0x4DCA},	{0,0x4DCB},
	{0,0x4DCC},	{0,0x4DCD},	{0,0x4DCE},	{0,0x4DCF},
	{0,0x4DD0},	{0,0x4DD1},	{0,0x4DD2},	{0,0x4DD3},
	{0,0x4DD4},	{0,0x4DD5},	{0,0x4DD6},	{0,0x4DD7},
	{0,0x4DD8},	{0,0x4DD9},	{0,0x4DDA},	{0,0x4DDB},
	{0,0x4DDC},	{0,0x4DDD},	{0,0x4DDE},	{0,0x4DDF},
	{0,0x4DE0},	{0,0x4DE1},	{0,0x4DE2},	{0,0x4DE3},
	{0,0x4DE4},	{0,0x4DE5},	{0,0x4DE6},	{0,0x4DE7},
	{0,0x4DE8},	{0,0x4DE9},	{0,0x4DEA},	{0,0x4DEB},
	{0,0x4DEC},	{0,0x4DED},	{0,0x4DEE},	{0,0x4DEF},
	{0,0x4DF0},	{0,0x4DF1},	{0,0x4DF2},	{0,0x4DF3},
	{0,0x4DF4},	{0,0x4DF5},	{0,0x4DF6},	{0,0x4DF7},
	{0,0x4DF8},	{0,0x4DF9},	{0,0x4DFA},	{0,0x4DFB},
	{0,0x4DFC},	{0,0x4DFD},	{0,0x4DFE},	{0,0x4DFF},
{0,0}};

static UDM_UNICODE plane9F[257]={
	{3,0x9F00},	{3,0x9F01},	{3,0x9F02},	{3,0x9F03},
	{3,0x9F04},	{3,0x9F05},	{3,0x9F06},	{3,0x9F07},
	{3,0x9F08},	{3,0x9F09},	{3,0x9F0A},	{3,0x9F0B},
	{3,0x9F0C},	{3,0x9F0D},	{3,0x9F0E},	{3,0x9F0F},
	{3,0x9F10},	{3,0x9F11},	{3,0x9F12},	{3,0x9F13},
	{3,0x9F14},	{3,0x9F15},	{3,0x9F16},	{3,0x9F17},
	{3,0x9F18},	{3,0x9F19},	{3,0x9F1A},	{3,0x9F1B},
	{3,0x9F1C},	{3,0x9F1D},	{3,0x9F1E},	{3,0x9F1F},
	{3,0x9F20},	{3,0x9F21},	{3,0x9F22},	{3,0x9F23},
	{3,0x9F24},	{3,0x9F25},	{3,0x9F26},	{3,0x9F27},
	{3,0x9F28},	{3,0x9F29},	{3,0x9F2A},	{3,0x9F2B},
	{3,0x9F2C},	{3,0x9F2D},	{3,0x9F2E},	{3,0x9F2F},
	{3,0x9F30},	{3,0x9F31},	{3,0x9F32},	{3,0x9F33},
	{3,0x9F34},	{3,0x9F35},	{3,0x9F36},	{3,0x9F37},
	{3,0x9F38},	{3,0x9F39},	{3,0x9F3A},	{3,0x9F3B},
	{3,0x9F3C},	{3,0x9F3D},	{3,0x9F3E},	{3,0x9F3F},
	{3,0x9F40},	{3,0x9F41},	{3,0x9F42},	{3,0x9F43},
	{3,0x9F44},	{3,0x9F45},	{3,0x9F46},	{3,0x9F47},
	{3,0x9F48},	{3,0x9F49},	{3,0x9F4A},	{3,0x9F4B},
	{3,0x9F4C},	{3,0x9F4D},	{3,0x9F4E},	{3,0x9F4F},
	{3,0x9F50},	{3,0x9F51},	{3,0x9F52},	{3,0x9F53},
	{3,0x9F54},	{3,0x9F55},	{3,0x9F56},	{3,0x9F57},
	{3,0x9F58},	{3,0x9F59},	{3,0x9F5A},	{3,0x9F5B},
	{3,0x9F5C},	{3,0x9F5D},	{3,0x9F5E},	{3,0x9F5F},
	{3,0x9F60},	{3,0x9F61},	{3,0x9F62},	{3,0x9F63},
	{3,0x9F64},	{3,0x9F65},	{3,0x9F66},	{3,0x9F67},
	{3,0x9F68},	{3,0x9F69},	{3,0x9F6A},	{3,0x9F6B},
	{3,0x9F6C},	{3,0x9F6D},	{3,0x9F6E},	{3,0x9F6F},
	{3,0x9F70},	{3,0x9F71},	{3,0x9F72},	{3,0x9F73},
	{3,0x9F74},	{3,0x9F75},	{3,0x9F76},	{3,0x9F77},
	{3,0x9F78},	{3,0x9F79},	{3,0x9F7A},	{3,0x9F7B},
	{3,0x9F7C},	{3,0x9F7D},	{3,0x9F7E},	{3,0x9F7F},
	{3,0x9F80},	{3,0x9F81},	{3,0x9F82},	{3,0x9F83},
	{3,0x9F84},	{3,0x9F85},	{3,0x9F86},	{3,0x9F87},
	{3,0x9F88},	{3,0x9F89},	{3,0x9F8A},	{3,0x9F8B},
	{3,0x9F8C},	{3,0x9F8D},	{3,0x9F8E},	{3,0x9F8F},
	{3,0x9F90},	{3,0x9F91},	{3,0x9F92},	{3,0x9F93},
	{3,0x9F94},	{3,0x9F95},	{3,0x9F96},	{3,0x9F97},
	{3,0x9F98},	{3,0x9F99},	{3,0x9F9A},	{3,0x9F9B},
	{3,0x9F9C},	{3,0x9F9D},	{3,0x9F9E},	{3,0x9F9F},
	{3,0x9FA0},	{3,0x9FA1},	{3,0x9FA2},	{3,0x9FA3},
	{3,0x9FA4},	{3,0x9FA5},	{0,0x9FA6},	{0,0x9FA7},
	{0,0x9FA8},	{0,0x9FA9},	{0,0x9FAA},	{0,0x9FAB},
	{0,0x9FAC},	{0,0x9FAD},	{0,0x9FAE},	{0,0x9FAF},
	{0,0x9FB0},	{0,0x9FB1},	{0,0x9FB2},	{0,0x9FB3},
	{0,0x9FB4},	{0,0x9FB5},	{0,0x9FB6},	{0,0x9FB7},
	{0,0x9FB8},	{0,0x9FB9},	{0,0x9FBA},	{0,0x9FBB},
	{0,0x9FBC},	{0,0x9FBD},	{0,0x9FBE},	{0,0x9FBF},
	{0,0x9FC0},	{0,0x9FC1},	{0,0x9FC2},	{0,0x9FC3},
	{0,0x9FC4},	{0,0x9FC5},	{0,0x9FC6},	{0,0x9FC7},
	{0,0x9FC8},	{0,0x9FC9},	{0,0x9FCA},	{0,0x9FCB},
	{0,0x9FCC},	{0,0x9FCD},	{0,0x9FCE},	{0,0x9FCF},
	{0,0x9FD0},	{0,0x9FD1},	{0,0x9FD2},	{0,0x9FD3},
	{0,0x9FD4},	{0,0x9FD5},	{0,0x9FD6},	{0,0x9FD7},
	{0,0x9FD8},	{0,0x9FD9},	{0,0x9FDA},	{0,0x9FDB},
	{0,0x9FDC},	{0,0x9FDD},	{0,0x9FDE},	{0,0x9FDF},
	{0,0x9FE0},	{0,0x9FE1},	{0,0x9FE2},	{0,0x9FE3},
	{0,0x9FE4},	{0,0x9FE5},	{0,0x9FE6},	{0,0x9FE7},
	{0,0x9FE8},	{0,0x9FE9},	{0,0x9FEA},	{0,0x9FEB},
	{0,0x9FEC},	{0,0x9FED},	{0,0x9FEE},	{0,0x9FEF},
	{0,0x9FF0},	{0,0x9FF1},	{0,0x9FF2},	{0,0x9FF3},
	{0,0x9FF4},	{0,0x9FF5},	{0,0x9FF6},	{0,0x9FF7},
	{0,0x9FF8},	{0,0x9FF9},	{0,0x9FFA},	{0,0x9FFB},
	{0,0x9FFC},	{0,0x9FFD},	{0,0x9FFE},	{0,0x9FFF},
{0,0}};

static UDM_UNICODE planeA4[257]={
	{1,0xA400},	{1,0xA401},	{1,0xA402},	{1,0xA403},
	{1,0xA404},	{1,0xA405},	{1,0xA406},	{1,0xA407},
	{1,0xA408},	{1,0xA409},	{1,0xA40A},	{1,0xA40B},
	{1,0xA40C},	{1,0xA40D},	{1,0xA40E},	{1,0xA40F},
	{1,0xA410},	{1,0xA411},	{1,0xA412},	{1,0xA413},
	{1,0xA414},	{1,0xA415},	{1,0xA416},	{1,0xA417},
	{1,0xA418},	{1,0xA419},	{1,0xA41A},	{1,0xA41B},
	{1,0xA41C},	{1,0xA41D},	{1,0xA41E},	{1,0xA41F},
	{1,0xA420},	{1,0xA421},	{1,0xA422},	{1,0xA423},
	{1,0xA424},	{1,0xA425},	{1,0xA426},	{1,0xA427},
	{1,0xA428},	{1,0xA429},	{1,0xA42A},	{1,0xA42B},
	{1,0xA42C},	{1,0xA42D},	{1,0xA42E},	{1,0xA42F},
	{1,0xA430},	{1,0xA431},	{1,0xA432},	{1,0xA433},
	{1,0xA434},	{1,0xA435},	{1,0xA436},	{1,0xA437},
	{1,0xA438},	{1,0xA439},	{1,0xA43A},	{1,0xA43B},
	{1,0xA43C},	{1,0xA43D},	{1,0xA43E},	{1,0xA43F},
	{1,0xA440},	{1,0xA441},	{1,0xA442},	{1,0xA443},
	{1,0xA444},	{1,0xA445},	{1,0xA446},	{1,0xA447},
	{1,0xA448},	{1,0xA449},	{1,0xA44A},	{1,0xA44B},
	{1,0xA44C},	{1,0xA44D},	{1,0xA44E},	{1,0xA44F},
	{1,0xA450},	{1,0xA451},	{1,0xA452},	{1,0xA453},
	{1,0xA454},	{1,0xA455},	{1,0xA456},	{1,0xA457},
	{1,0xA458},	{1,0xA459},	{1,0xA45A},	{1,0xA45B},
	{1,0xA45C},	{1,0xA45D},	{1,0xA45E},	{1,0xA45F},
	{1,0xA460},	{1,0xA461},	{1,0xA462},	{1,0xA463},
	{1,0xA464},	{1,0xA465},	{1,0xA466},	{1,0xA467},
	{1,0xA468},	{1,0xA469},	{1,0xA46A},	{1,0xA46B},
	{1,0xA46C},	{1,0xA46D},	{1,0xA46E},	{1,0xA46F},
	{1,0xA470},	{1,0xA471},	{1,0xA472},	{1,0xA473},
	{1,0xA474},	{1,0xA475},	{1,0xA476},	{1,0xA477},
	{1,0xA478},	{1,0xA479},	{1,0xA47A},	{1,0xA47B},
	{1,0xA47C},	{1,0xA47D},	{1,0xA47E},	{1,0xA47F},
	{1,0xA480},	{1,0xA481},	{1,0xA482},	{1,0xA483},
	{1,0xA484},	{1,0xA485},	{1,0xA486},	{1,0xA487},
	{1,0xA488},	{1,0xA489},	{1,0xA48A},	{1,0xA48B},
	{1,0xA48C},	{0,0xA48D},	{0,0xA48E},	{0,0xA48F},
	{0,0xA490},	{0,0xA491},	{0,0xA492},	{0,0xA493},
	{0,0xA494},	{0,0xA495},	{0,0xA496},	{0,0xA497},
	{0,0xA498},	{0,0xA499},	{0,0xA49A},	{0,0xA49B},
	{0,0xA49C},	{0,0xA49D},	{0,0xA49E},	{0,0xA49F},
	{0,0xA4A0},	{0,0xA4A1},	{0,0xA4A2},	{0,0xA4A3},
	{0,0xA4A4},	{0,0xA4A5},	{0,0xA4A6},	{0,0xA4A7},
	{0,0xA4A8},	{0,0xA4A9},	{0,0xA4AA},	{0,0xA4AB},
	{0,0xA4AC},	{0,0xA4AD},	{0,0xA4AE},	{0,0xA4AF},
	{0,0xA4B0},	{0,0xA4B1},	{0,0xA4B2},	{0,0xA4B3},
	{0,0xA4B4},	{0,0xA4B5},	{0,0xA4B6},	{0,0xA4B7},
	{0,0xA4B8},	{0,0xA4B9},	{0,0xA4BA},	{0,0xA4BB},
	{0,0xA4BC},	{0,0xA4BD},	{0,0xA4BE},	{0,0xA4BF},
	{0,0xA4C0},	{0,0xA4C1},	{0,0xA4C2},	{0,0xA4C3},
	{0,0xA4C4},	{0,0xA4C5},	{0,0xA4C6},	{0,0xA4C7},
	{0,0xA4C8},	{0,0xA4C9},	{0,0xA4CA},	{0,0xA4CB},
	{0,0xA4CC},	{0,0xA4CD},	{0,0xA4CE},	{0,0xA4CF},
	{0,0xA4D0},	{0,0xA4D1},	{0,0xA4D2},	{0,0xA4D3},
	{0,0xA4D4},	{0,0xA4D5},	{0,0xA4D6},	{0,0xA4D7},
	{0,0xA4D8},	{0,0xA4D9},	{0,0xA4DA},	{0,0xA4DB},
	{0,0xA4DC},	{0,0xA4DD},	{0,0xA4DE},	{0,0xA4DF},
	{0,0xA4E0},	{0,0xA4E1},	{0,0xA4E2},	{0,0xA4E3},
	{0,0xA4E4},	{0,0xA4E5},	{0,0xA4E6},	{0,0xA4E7},
	{0,0xA4E8},	{0,0xA4E9},	{0,0xA4EA},	{0,0xA4EB},
	{0,0xA4EC},	{0,0xA4ED},	{0,0xA4EE},	{0,0xA4EF},
	{0,0xA4F0},	{0,0xA4F1},	{0,0xA4F2},	{0,0xA4F3},
	{0,0xA4F4},	{0,0xA4F5},	{0,0xA4F6},	{0,0xA4F7},
	{0,0xA4F8},	{0,0xA4F9},	{0,0xA4FA},	{0,0xA4FB},
	{0,0xA4FC},	{0,0xA4FD},	{0,0xA4FE},	{0,0xA4FF},
{0,0}};

static UDM_UNICODE planeD7[257]={
	{1,0xD700},	{1,0xD701},	{1,0xD702},	{1,0xD703},
	{1,0xD704},	{1,0xD705},	{1,0xD706},	{1,0xD707},
	{1,0xD708},	{1,0xD709},	{1,0xD70A},	{1,0xD70B},
	{1,0xD70C},	{1,0xD70D},	{1,0xD70E},	{1,0xD70F},
	{1,0xD710},	{1,0xD711},	{1,0xD712},	{1,0xD713},
	{1,0xD714},	{1,0xD715},	{1,0xD716},	{1,0xD717},
	{1,0xD718},	{1,0xD719},	{1,0xD71A},	{1,0xD71B},
	{1,0xD71C},	{1,0xD71D},	{1,0xD71E},	{1,0xD71F},
	{1,0xD720},	{1,0xD721},	{1,0xD722},	{1,0xD723},
	{1,0xD724},	{1,0xD725},	{1,0xD726},	{1,0xD727},
	{1,0xD728},	{1,0xD729},	{1,0xD72A},	{1,0xD72B},
	{1,0xD72C},	{1,0xD72D},	{1,0xD72E},	{1,0xD72F},
	{1,0xD730},	{1,0xD731},	{1,0xD732},	{1,0xD733},
	{1,0xD734},	{1,0xD735},	{1,0xD736},	{1,0xD737},
	{1,0xD738},	{1,0xD739},	{1,0xD73A},	{1,0xD73B},
	{1,0xD73C},	{1,0xD73D},	{1,0xD73E},	{1,0xD73F},
	{1,0xD740},	{1,0xD741},	{1,0xD742},	{1,0xD743},
	{1,0xD744},	{1,0xD745},	{1,0xD746},	{1,0xD747},
	{1,0xD748},	{1,0xD749},	{1,0xD74A},	{1,0xD74B},
	{1,0xD74C},	{1,0xD74D},	{1,0xD74E},	{1,0xD74F},
	{1,0xD750},	{1,0xD751},	{1,0xD752},	{1,0xD753},
	{1,0xD754},	{1,0xD755},	{1,0xD756},	{1,0xD757},
	{1,0xD758},	{1,0xD759},	{1,0xD75A},	{1,0xD75B},
	{1,0xD75C},	{1,0xD75D},	{1,0xD75E},	{1,0xD75F},
	{1,0xD760},	{1,0xD761},	{1,0xD762},	{1,0xD763},
	{1,0xD764},	{1,0xD765},	{1,0xD766},	{1,0xD767},
	{1,0xD768},	{1,0xD769},	{1,0xD76A},	{1,0xD76B},
	{1,0xD76C},	{1,0xD76D},	{1,0xD76E},	{1,0xD76F},
	{1,0xD770},	{1,0xD771},	{1,0xD772},	{1,0xD773},
	{1,0xD774},	{1,0xD775},	{1,0xD776},	{1,0xD777},
	{1,0xD778},	{1,0xD779},	{1,0xD77A},	{1,0xD77B},
	{1,0xD77C},	{1,0xD77D},	{1,0xD77E},	{1,0xD77F},
	{1,0xD780},	{1,0xD781},	{1,0xD782},	{1,0xD783},
	{1,0xD784},	{1,0xD785},	{1,0xD786},	{1,0xD787},
	{1,0xD788},	{1,0xD789},	{1,0xD78A},	{1,0xD78B},
	{1,0xD78C},	{1,0xD78D},	{1,0xD78E},	{1,0xD78F},
	{1,0xD790},	{1,0xD791},	{1,0xD792},	{1,0xD793},
	{1,0xD794},	{1,0xD795},	{1,0xD796},	{1,0xD797},
	{1,0xD798},	{1,0xD799},	{1,0xD79A},	{1,0xD79B},
	{1,0xD79C},	{1,0xD79D},	{1,0xD79E},	{1,0xD79F},
	{1,0xD7A0},	{1,0xD7A1},	{1,0xD7A2},	{1,0xD7A3},
	{0,0xD7A4},	{0,0xD7A5},	{0,0xD7A6},	{0,0xD7A7},
	{0,0xD7A8},	{0,0xD7A9},	{0,0xD7AA},	{0,0xD7AB},
	{0,0xD7AC},	{0,0xD7AD},	{0,0xD7AE},	{0,0xD7AF},
	{0,0xD7B0},	{0,0xD7B1},	{0,0xD7B2},	{0,0xD7B3},
	{0,0xD7B4},	{0,0xD7B5},	{0,0xD7B6},	{0,0xD7B7},
	{0,0xD7B8},	{0,0xD7B9},	{0,0xD7BA},	{0,0xD7BB},
	{0,0xD7BC},	{0,0xD7BD},	{0,0xD7BE},	{0,0xD7BF},
	{0,0xD7C0},	{0,0xD7C1},	{0,0xD7C2},	{0,0xD7C3},
	{0,0xD7C4},	{0,0xD7C5},	{0,0xD7C6},	{0,0xD7C7},
	{0,0xD7C8},	{0,0xD7C9},	{0,0xD7CA},	{0,0xD7CB},
	{0,0xD7CC},	{0,0xD7CD},	{0,0xD7CE},	{0,0xD7CF},
	{0,0xD7D0},	{0,0xD7D1},	{0,0xD7D2},	{0,0xD7D3},
	{0,0xD7D4},	{0,0xD7D5},	{0,0xD7D6},	{0,0xD7D7},
	{0,0xD7D8},	{0,0xD7D9},	{0,0xD7DA},	{0,0xD7DB},
	{0,0xD7DC},	{0,0xD7DD},	{0,0xD7DE},	{0,0xD7DF},
	{0,0xD7E0},	{0,0xD7E1},	{0,0xD7E2},	{0,0xD7E3},
	{0,0xD7E4},	{0,0xD7E5},	{0,0xD7E6},	{0,0xD7E7},
	{0,0xD7E8},	{0,0xD7E9},	{0,0xD7EA},	{0,0xD7EB},
	{0,0xD7EC},	{0,0xD7ED},	{0,0xD7EE},	{0,0xD7EF},
	{0,0xD7F0},	{0,0xD7F1},	{0,0xD7F2},	{0,0xD7F3},
	{0,0xD7F4},	{0,0xD7F5},	{0,0xD7F6},	{0,0xD7F7},
	{0,0xD7F8},	{0,0xD7F9},	{0,0xD7FA},	{0,0xD7FB},
	{0,0xD7FC},	{0,0xD7FD},	{0,0xD7FE},	{0,0xD7FF},
{0,0}};

static UDM_UNICODE planeFA[257]={
	{1,0xFA00},	{1,0xFA01},	{1,0xFA02},	{1,0xFA03},
	{1,0xFA04},	{1,0xFA05},	{1,0xFA06},	{1,0xFA07},
	{1,0xFA08},	{1,0xFA09},	{1,0xFA0A},	{1,0xFA0B},
	{1,0xFA0C},	{1,0xFA0D},	{1,0xFA0E},	{1,0xFA0F},
	{1,0xFA10},	{1,0xFA11},	{1,0xFA12},	{1,0xFA13},
	{1,0xFA14},	{1,0xFA15},	{1,0xFA16},	{1,0xFA17},
	{1,0xFA18},	{1,0xFA19},	{1,0xFA1A},	{1,0xFA1B},
	{1,0xFA1C},	{1,0xFA1D},	{1,0xFA1E},	{1,0xFA1F},
	{1,0xFA20},	{1,0xFA21},	{1,0xFA22},	{1,0xFA23},
	{1,0xFA24},	{1,0xFA25},	{1,0xFA26},	{1,0xFA27},
	{1,0xFA28},	{1,0xFA29},	{1,0xFA2A},	{1,0xFA2B},
	{1,0xFA2C},	{1,0xFA2D},	{0,0xFA2E},	{0,0xFA2F},
	{0,0xFA30},	{0,0xFA31},	{0,0xFA32},	{0,0xFA33},
	{0,0xFA34},	{0,0xFA35},	{0,0xFA36},	{0,0xFA37},
	{0,0xFA38},	{0,0xFA39},	{0,0xFA3A},	{0,0xFA3B},
	{0,0xFA3C},	{0,0xFA3D},	{0,0xFA3E},	{0,0xFA3F},
	{0,0xFA40},	{0,0xFA41},	{0,0xFA42},	{0,0xFA43},
	{0,0xFA44},	{0,0xFA45},	{0,0xFA46},	{0,0xFA47},
	{0,0xFA48},	{0,0xFA49},	{0,0xFA4A},	{0,0xFA4B},
	{0,0xFA4C},	{0,0xFA4D},	{0,0xFA4E},	{0,0xFA4F},
	{0,0xFA50},	{0,0xFA51},	{0,0xFA52},	{0,0xFA53},
	{0,0xFA54},	{0,0xFA55},	{0,0xFA56},	{0,0xFA57},
	{0,0xFA58},	{0,0xFA59},	{0,0xFA5A},	{0,0xFA5B},
	{0,0xFA5C},	{0,0xFA5D},	{0,0xFA5E},	{0,0xFA5F},
	{0,0xFA60},	{0,0xFA61},	{0,0xFA62},	{0,0xFA63},
	{0,0xFA64},	{0,0xFA65},	{0,0xFA66},	{0,0xFA67},
	{0,0xFA68},	{0,0xFA69},	{0,0xFA6A},	{0,0xFA6B},
	{0,0xFA6C},	{0,0xFA6D},	{0,0xFA6E},	{0,0xFA6F},
	{0,0xFA70},	{0,0xFA71},	{0,0xFA72},	{0,0xFA73},
	{0,0xFA74},	{0,0xFA75},	{0,0xFA76},	{0,0xFA77},
	{0,0xFA78},	{0,0xFA79},	{0,0xFA7A},	{0,0xFA7B},
	{0,0xFA7C},	{0,0xFA7D},	{0,0xFA7E},	{0,0xFA7F},
	{0,0xFA80},	{0,0xFA81},	{0,0xFA82},	{0,0xFA83},
	{0,0xFA84},	{0,0xFA85},	{0,0xFA86},	{0,0xFA87},
	{0,0xFA88},	{0,0xFA89},	{0,0xFA8A},	{0,0xFA8B},
	{0,0xFA8C},	{0,0xFA8D},	{0,0xFA8E},	{0,0xFA8F},
	{0,0xFA90},	{0,0xFA91},	{0,0xFA92},	{0,0xFA93},
	{0,0xFA94},	{0,0xFA95},	{0,0xFA96},	{0,0xFA97},
	{0,0xFA98},	{0,0xFA99},	{0,0xFA9A},	{0,0xFA9B},
	{0,0xFA9C},	{0,0xFA9D},	{0,0xFA9E},	{0,0xFA9F},
	{0,0xFAA0},	{0,0xFAA1},	{0,0xFAA2},	{0,0xFAA3},
	{0,0xFAA4},	{0,0xFAA5},	{0,0xFAA6},	{0,0xFAA7},
	{0,0xFAA8},	{0,0xFAA9},	{0,0xFAAA},	{0,0xFAAB},
	{0,0xFAAC},	{0,0xFAAD},	{0,0xFAAE},	{0,0xFAAF},
	{0,0xFAB0},	{0,0xFAB1},	{0,0xFAB2},	{0,0xFAB3},
	{0,0xFAB4},	{0,0xFAB5},	{0,0xFAB6},	{0,0xFAB7},
	{0,0xFAB8},	{0,0xFAB9},	{0,0xFABA},	{0,0xFABB},
	{0,0xFABC},	{0,0xFABD},	{0,0xFABE},	{0,0xFABF},
	{0,0xFAC0},	{0,0xFAC1},	{0,0xFAC2},	{0,0xFAC3},
	{0,0xFAC4},	{0,0xFAC5},	{0,0xFAC6},	{0,0xFAC7},
	{0,0xFAC8},	{0,0xFAC9},	{0,0xFACA},	{0,0xFACB},
	{0,0xFACC},	{0,0xFACD},	{0,0xFACE},	{0,0xFACF},
	{0,0xFAD0},	{0,0xFAD1},	{0,0xFAD2},	{0,0xFAD3},
	{0,0xFAD4},	{0,0xFAD5},	{0,0xFAD6},	{0,0xFAD7},
	{0,0xFAD8},	{0,0xFAD9},	{0,0xFADA},	{0,0xFADB},
	{0,0xFADC},	{0,0xFADD},	{0,0xFADE},	{0,0xFADF},
	{0,0xFAE0},	{0,0xFAE1},	{0,0xFAE2},	{0,0xFAE3},
	{0,0xFAE4},	{0,0xFAE5},	{0,0xFAE6},	{0,0xFAE7},
	{0,0xFAE8},	{0,0xFAE9},	{0,0xFAEA},	{0,0xFAEB},
	{0,0xFAEC},	{0,0xFAED},	{0,0xFAEE},	{0,0xFAEF},
	{0,0xFAF0},	{0,0xFAF1},	{0,0xFAF2},	{0,0xFAF3},
	{0,0xFAF4},	{0,0xFAF5},	{0,0xFAF6},	{0,0xFAF7},
	{0,0xFAF8},	{0,0xFAF9},	{0,0xFAFA},	{0,0xFAFB},
	{0,0xFAFC},	{0,0xFAFD},	{0,0xFAFE},	{0,0xFAFF},
{0,0}};

static UDM_UNICODE planeFB[257]={
	{1,0xFB00},	{1,0xFB01},	{1,0xFB02},	{1,0xFB03},
	{1,0xFB04},	{1,0xFB05},	{1,0xFB06},	{0,0xFB07},
	{0,0xFB08},	{0,0xFB09},	{0,0xFB0A},	{0,0xFB0B},
	{0,0xFB0C},	{0,0xFB0D},	{0,0xFB0E},	{0,0xFB0F},
	{0,0xFB10},	{0,0xFB11},	{0,0xFB12},	{1,0xFB13},
	{1,0xFB14},	{1,0xFB15},	{1,0xFB16},	{1,0xFB17},
	{0,0xFB18},	{0,0xFB19},	{0,0xFB1A},	{0,0xFB1B},
	{0,0xFB1C},	{1,0xFB1D},	{1,0xFB1E},	{1,0xFB1F},
	{1,0xFB20},	{1,0xFB21},	{1,0xFB22},	{1,0xFB23},
	{1,0xFB24},	{1,0xFB25},	{1,0xFB26},	{1,0xFB27},
	{1,0xFB28},	{0,0xFB29},	{1,0xFB2A},	{1,0xFB2B},
	{1,0xFB2C},	{1,0xFB2D},	{1,0xFB2E},	{1,0xFB2F},
	{1,0xFB30},	{1,0xFB31},	{1,0xFB32},	{1,0xFB33},
	{1,0xFB34},	{1,0xFB35},	{1,0xFB36},	{0,0xFB37},
	{1,0xFB38},	{1,0xFB39},	{1,0xFB3A},	{1,0xFB3B},
	{1,0xFB3C},	{0,0xFB3D},	{1,0xFB3E},	{0,0xFB3F},
	{1,0xFB40},	{1,0xFB41},	{0,0xFB42},	{1,0xFB43},
	{1,0xFB44},	{0,0xFB45},	{1,0xFB46},	{1,0xFB47},
	{1,0xFB48},	{1,0xFB49},	{1,0xFB4A},	{1,0xFB4B},
	{1,0xFB4C},	{1,0xFB4D},	{1,0xFB4E},	{1,0xFB4F},
	{1,0xFB50},	{1,0xFB51},	{1,0xFB52},	{1,0xFB53},
	{1,0xFB54},	{1,0xFB55},	{1,0xFB56},	{1,0xFB57},
	{1,0xFB58},	{1,0xFB59},	{1,0xFB5A},	{1,0xFB5B},
	{1,0xFB5C},	{1,0xFB5D},	{1,0xFB5E},	{1,0xFB5F},
	{1,0xFB60},	{1,0xFB61},	{1,0xFB62},	{1,0xFB63},
	{1,0xFB64},	{1,0xFB65},	{1,0xFB66},	{1,0xFB67},
	{1,0xFB68},	{1,0xFB69},	{1,0xFB6A},	{1,0xFB6B},
	{1,0xFB6C},	{1,0xFB6D},	{1,0xFB6E},	{1,0xFB6F},
	{1,0xFB70},	{1,0xFB71},	{1,0xFB72},	{1,0xFB73},
	{1,0xFB74},	{1,0xFB75},	{1,0xFB76},	{1,0xFB77},
	{1,0xFB78},	{1,0xFB79},	{1,0xFB7A},	{1,0xFB7B},
	{1,0xFB7C},	{1,0xFB7D},	{1,0xFB7E},	{1,0xFB7F},
	{1,0xFB80},	{1,0xFB81},	{1,0xFB82},	{1,0xFB83},
	{1,0xFB84},	{1,0xFB85},	{1,0xFB86},	{1,0xFB87},
	{1,0xFB88},	{1,0xFB89},	{1,0xFB8A},	{1,0xFB8B},
	{1,0xFB8C},	{1,0xFB8D},	{1,0xFB8E},	{1,0xFB8F},
	{1,0xFB90},	{1,0xFB91},	{1,0xFB92},	{1,0xFB93},
	{1,0xFB94},	{1,0xFB95},	{1,0xFB96},	{1,0xFB97},
	{1,0xFB98},	{1,0xFB99},	{1,0xFB9A},	{1,0xFB9B},
	{1,0xFB9C},	{1,0xFB9D},	{1,0xFB9E},	{1,0xFB9F},
	{1,0xFBA0},	{1,0xFBA1},	{1,0xFBA2},	{1,0xFBA3},
	{1,0xFBA4},	{1,0xFBA5},	{1,0xFBA6},	{1,0xFBA7},
	{1,0xFBA8},	{1,0xFBA9},	{1,0xFBAA},	{1,0xFBAB},
	{1,0xFBAC},	{1,0xFBAD},	{1,0xFBAE},	{1,0xFBAF},
	{1,0xFBB0},	{1,0xFBB1},	{0,0xFBB2},	{0,0xFBB3},
	{0,0xFBB4},	{0,0xFBB5},	{0,0xFBB6},	{0,0xFBB7},
	{0,0xFBB8},	{0,0xFBB9},	{0,0xFBBA},	{0,0xFBBB},
	{0,0xFBBC},	{0,0xFBBD},	{0,0xFBBE},	{0,0xFBBF},
	{0,0xFBC0},	{0,0xFBC1},	{0,0xFBC2},	{0,0xFBC3},
	{0,0xFBC4},	{0,0xFBC5},	{0,0xFBC6},	{0,0xFBC7},
	{0,0xFBC8},	{0,0xFBC9},	{0,0xFBCA},	{0,0xFBCB},
	{0,0xFBCC},	{0,0xFBCD},	{0,0xFBCE},	{0,0xFBCF},
	{0,0xFBD0},	{0,0xFBD1},	{0,0xFBD2},	{1,0xFBD3},
	{1,0xFBD4},	{1,0xFBD5},	{1,0xFBD6},	{1,0xFBD7},
	{1,0xFBD8},	{1,0xFBD9},	{1,0xFBDA},	{1,0xFBDB},
	{1,0xFBDC},	{1,0xFBDD},	{1,0xFBDE},	{1,0xFBDF},
	{1,0xFBE0},	{1,0xFBE1},	{1,0xFBE2},	{1,0xFBE3},
	{1,0xFBE4},	{1,0xFBE5},	{1,0xFBE6},	{1,0xFBE7},
	{1,0xFBE8},	{1,0xFBE9},	{1,0xFBEA},	{1,0xFBEB},
	{1,0xFBEC},	{1,0xFBED},	{1,0xFBEE},	{1,0xFBEF},
	{1,0xFBF0},	{1,0xFBF1},	{1,0xFBF2},	{1,0xFBF3},
	{1,0xFBF4},	{1,0xFBF5},	{1,0xFBF6},	{1,0xFBF7},
	{1,0xFBF8},	{1,0xFBF9},	{1,0xFBFA},	{1,0xFBFB},
	{1,0xFBFC},	{1,0xFBFD},	{1,0xFBFE},	{1,0xFBFF},
{0,0}};

static UDM_UNICODE planeFD[257]={
	{1,0xFD00},	{1,0xFD01},	{1,0xFD02},	{1,0xFD03},
	{1,0xFD04},	{1,0xFD05},	{1,0xFD06},	{1,0xFD07},
	{1,0xFD08},	{1,0xFD09},	{1,0xFD0A},	{1,0xFD0B},
	{1,0xFD0C},	{1,0xFD0D},	{1,0xFD0E},	{1,0xFD0F},
	{1,0xFD10},	{1,0xFD11},	{1,0xFD12},	{1,0xFD13},
	{1,0xFD14},	{1,0xFD15},	{1,0xFD16},	{1,0xFD17},
	{1,0xFD18},	{1,0xFD19},	{1,0xFD1A},	{1,0xFD1B},
	{1,0xFD1C},	{1,0xFD1D},	{1,0xFD1E},	{1,0xFD1F},
	{1,0xFD20},	{1,0xFD21},	{1,0xFD22},	{1,0xFD23},
	{1,0xFD24},	{1,0xFD25},	{1,0xFD26},	{1,0xFD27},
	{1,0xFD28},	{1,0xFD29},	{1,0xFD2A},	{1,0xFD2B},
	{1,0xFD2C},	{1,0xFD2D},	{1,0xFD2E},	{1,0xFD2F},
	{1,0xFD30},	{1,0xFD31},	{1,0xFD32},	{1,0xFD33},
	{1,0xFD34},	{1,0xFD35},	{1,0xFD36},	{1,0xFD37},
	{1,0xFD38},	{1,0xFD39},	{1,0xFD3A},	{1,0xFD3B},
	{1,0xFD3C},	{1,0xFD3D},	{0,0xFD3E},	{0,0xFD3F},
	{0,0xFD40},	{0,0xFD41},	{0,0xFD42},	{0,0xFD43},
	{0,0xFD44},	{0,0xFD45},	{0,0xFD46},	{0,0xFD47},
	{0,0xFD48},	{0,0xFD49},	{0,0xFD4A},	{0,0xFD4B},
	{0,0xFD4C},	{0,0xFD4D},	{0,0xFD4E},	{0,0xFD4F},
	{1,0xFD50},	{1,0xFD51},	{1,0xFD52},	{1,0xFD53},
	{1,0xFD54},	{1,0xFD55},	{1,0xFD56},	{1,0xFD57},
	{1,0xFD58},	{1,0xFD59},	{1,0xFD5A},	{1,0xFD5B},
	{1,0xFD5C},	{1,0xFD5D},	{1,0xFD5E},	{1,0xFD5F},
	{1,0xFD60},	{1,0xFD61},	{1,0xFD62},	{1,0xFD63},
	{1,0xFD64},	{1,0xFD65},	{1,0xFD66},	{1,0xFD67},
	{1,0xFD68},	{1,0xFD69},	{1,0xFD6A},	{1,0xFD6B},
	{1,0xFD6C},	{1,0xFD6D},	{1,0xFD6E},	{1,0xFD6F},
	{1,0xFD70},	{1,0xFD71},	{1,0xFD72},	{1,0xFD73},
	{1,0xFD74},	{1,0xFD75},	{1,0xFD76},	{1,0xFD77},
	{1,0xFD78},	{1,0xFD79},	{1,0xFD7A},	{1,0xFD7B},
	{1,0xFD7C},	{1,0xFD7D},	{1,0xFD7E},	{1,0xFD7F},
	{1,0xFD80},	{1,0xFD81},	{1,0xFD82},	{1,0xFD83},
	{1,0xFD84},	{1,0xFD85},	{1,0xFD86},	{1,0xFD87},
	{1,0xFD88},	{1,0xFD89},	{1,0xFD8A},	{1,0xFD8B},
	{1,0xFD8C},	{1,0xFD8D},	{1,0xFD8E},	{1,0xFD8F},
	{0,0xFD90},	{0,0xFD91},	{1,0xFD92},	{1,0xFD93},
	{1,0xFD94},	{1,0xFD95},	{1,0xFD96},	{1,0xFD97},
	{1,0xFD98},	{1,0xFD99},	{1,0xFD9A},	{1,0xFD9B},
	{1,0xFD9C},	{1,0xFD9D},	{1,0xFD9E},	{1,0xFD9F},
	{1,0xFDA0},	{1,0xFDA1},	{1,0xFDA2},	{1,0xFDA3},
	{1,0xFDA4},	{1,0xFDA5},	{1,0xFDA6},	{1,0xFDA7},
	{1,0xFDA8},	{1,0xFDA9},	{1,0xFDAA},	{1,0xFDAB},
	{1,0xFDAC},	{1,0xFDAD},	{1,0xFDAE},	{1,0xFDAF},
	{1,0xFDB0},	{1,0xFDB1},	{1,0xFDB2},	{1,0xFDB3},
	{1,0xFDB4},	{1,0xFDB5},	{1,0xFDB6},	{1,0xFDB7},
	{1,0xFDB8},	{1,0xFDB9},	{1,0xFDBA},	{1,0xFDBB},
	{1,0xFDBC},	{1,0xFDBD},	{1,0xFDBE},	{1,0xFDBF},
	{1,0xFDC0},	{1,0xFDC1},	{1,0xFDC2},	{1,0xFDC3},
	{1,0xFDC4},	{1,0xFDC5},	{1,0xFDC6},	{1,0xFDC7},
	{0,0xFDC8},	{0,0xFDC9},	{0,0xFDCA},	{0,0xFDCB},
	{0,0xFDCC},	{0,0xFDCD},	{0,0xFDCE},	{0,0xFDCF},
	{0,0xFDD0},	{0,0xFDD1},	{0,0xFDD2},	{0,0xFDD3},
	{0,0xFDD4},	{0,0xFDD5},	{0,0xFDD6},	{0,0xFDD7},
	{0,0xFDD8},	{0,0xFDD9},	{0,0xFDDA},	{0,0xFDDB},
	{0,0xFDDC},	{0,0xFDDD},	{0,0xFDDE},	{0,0xFDDF},
	{0,0xFDE0},	{0,0xFDE1},	{0,0xFDE2},	{0,0xFDE3},
	{0,0xFDE4},	{0,0xFDE5},	{0,0xFDE6},	{0,0xFDE7},
	{0,0xFDE8},	{0,0xFDE9},	{0,0xFDEA},	{0,0xFDEB},
	{0,0xFDEC},	{0,0xFDED},	{0,0xFDEE},	{0,0xFDEF},
	{1,0xFDF0},	{1,0xFDF1},	{1,0xFDF2},	{1,0xFDF3},
	{1,0xFDF4},	{1,0xFDF5},	{1,0xFDF6},	{1,0xFDF7},
	{1,0xFDF8},	{1,0xFDF9},	{1,0xFDFA},	{1,0xFDFB},
	{0,0xFDFC},	{0,0xFDFD},	{0,0xFDFE},	{0,0xFDFF},
{0,0}};

static UDM_UNICODE planeFE[257]={
	{0,0xFE00},	{0,0xFE01},	{0,0xFE02},	{0,0xFE03},
	{0,0xFE04},	{0,0xFE05},	{0,0xFE06},	{0,0xFE07},
	{0,0xFE08},	{0,0xFE09},	{0,0xFE0A},	{0,0xFE0B},
	{0,0xFE0C},	{0,0xFE0D},	{0,0xFE0E},	{0,0xFE0F},
	{0,0xFE10},	{0,0xFE11},	{0,0xFE12},	{0,0xFE13},
	{0,0xFE14},	{0,0xFE15},	{0,0xFE16},	{0,0xFE17},
	{0,0xFE18},	{0,0xFE19},	{0,0xFE1A},	{0,0xFE1B},
	{0,0xFE1C},	{0,0xFE1D},	{0,0xFE1E},	{0,0xFE1F},
	{1,0xFE20},	{1,0xFE21},	{1,0xFE22},	{1,0xFE23},
	{0,0xFE24},	{0,0xFE25},	{0,0xFE26},	{0,0xFE27},
	{0,0xFE28},	{0,0xFE29},	{0,0xFE2A},	{0,0xFE2B},
	{0,0xFE2C},	{0,0xFE2D},	{0,0xFE2E},	{0,0xFE2F},
	{0,0xFE30},	{0,0xFE31},	{0,0xFE32},	{0,0xFE33},
	{0,0xFE34},	{0,0xFE35},	{0,0xFE36},	{0,0xFE37},
	{0,0xFE38},	{0,0xFE39},	{0,0xFE3A},	{0,0xFE3B},
	{0,0xFE3C},	{0,0xFE3D},	{0,0xFE3E},	{0,0xFE3F},
	{0,0xFE40},	{0,0xFE41},	{0,0xFE42},	{0,0xFE43},
	{0,0xFE44},	{0,0xFE45},	{0,0xFE46},	{0,0xFE47},
	{0,0xFE48},	{0,0xFE49},	{0,0xFE4A},	{0,0xFE4B},
	{0,0xFE4C},	{0,0xFE4D},	{0,0xFE4E},	{0,0xFE4F},
	{0,0xFE50},	{0,0xFE51},	{0,0xFE52},	{0,0xFE53},
	{0,0xFE54},	{0,0xFE55},	{0,0xFE56},	{0,0xFE57},
	{0,0xFE58},	{0,0xFE59},	{0,0xFE5A},	{0,0xFE5B},
	{0,0xFE5C},	{0,0xFE5D},	{0,0xFE5E},	{0,0xFE5F},
	{0,0xFE60},	{0,0xFE61},	{0,0xFE62},	{0,0xFE63},
	{0,0xFE64},	{0,0xFE65},	{0,0xFE66},	{0,0xFE67},
	{0,0xFE68},	{0,0xFE69},	{0,0xFE6A},	{0,0xFE6B},
	{0,0xFE6C},	{0,0xFE6D},	{0,0xFE6E},	{0,0xFE6F},
	{1,0xFE70},	{1,0xFE71},	{1,0xFE72},	{0,0xFE73},
	{1,0xFE74},	{0,0xFE75},	{1,0xFE76},	{1,0xFE77},
	{1,0xFE78},	{1,0xFE79},	{1,0xFE7A},	{1,0xFE7B},
	{1,0xFE7C},	{1,0xFE7D},	{1,0xFE7E},	{1,0xFE7F},
	{1,0xFE80},	{1,0xFE81},	{1,0xFE82},	{1,0xFE83},
	{1,0xFE84},	{1,0xFE85},	{1,0xFE86},	{1,0xFE87},
	{1,0xFE88},	{1,0xFE89},	{1,0xFE8A},	{1,0xFE8B},
	{1,0xFE8C},	{1,0xFE8D},	{1,0xFE8E},	{1,0xFE8F},
	{1,0xFE90},	{1,0xFE91},	{1,0xFE92},	{1,0xFE93},
	{1,0xFE94},	{1,0xFE95},	{1,0xFE96},	{1,0xFE97},
	{1,0xFE98},	{1,0xFE99},	{1,0xFE9A},	{1,0xFE9B},
	{1,0xFE9C},	{1,0xFE9D},	{1,0xFE9E},	{1,0xFE9F},
	{1,0xFEA0},	{1,0xFEA1},	{1,0xFEA2},	{1,0xFEA3},
	{1,0xFEA4},	{1,0xFEA5},	{1,0xFEA6},	{1,0xFEA7},
	{1,0xFEA8},	{1,0xFEA9},	{1,0xFEAA},	{1,0xFEAB},
	{1,0xFEAC},	{1,0xFEAD},	{1,0xFEAE},	{1,0xFEAF},
	{1,0xFEB0},	{1,0xFEB1},	{1,0xFEB2},	{1,0xFEB3},
	{1,0xFEB4},	{1,0xFEB5},	{1,0xFEB6},	{1,0xFEB7},
	{1,0xFEB8},	{1,0xFEB9},	{1,0xFEBA},	{1,0xFEBB},
	{1,0xFEBC},	{1,0xFEBD},	{1,0xFEBE},	{1,0xFEBF},
	{1,0xFEC0},	{1,0xFEC1},	{1,0xFEC2},	{1,0xFEC3},
	{1,0xFEC4},	{1,0xFEC5},	{1,0xFEC6},	{1,0xFEC7},
	{1,0xFEC8},	{1,0xFEC9},	{1,0xFECA},	{1,0xFECB},
	{1,0xFECC},	{1,0xFECD},	{1,0xFECE},	{1,0xFECF},
	{1,0xFED0},	{1,0xFED1},	{1,0xFED2},	{1,0xFED3},
	{1,0xFED4},	{1,0xFED5},	{1,0xFED6},	{1,0xFED7},
	{1,0xFED8},	{1,0xFED9},	{1,0xFEDA},	{1,0xFEDB},
	{1,0xFEDC},	{1,0xFEDD},	{1,0xFEDE},	{1,0xFEDF},
	{1,0xFEE0},	{1,0xFEE1},	{1,0xFEE2},	{1,0xFEE3},
	{1,0xFEE4},	{1,0xFEE5},	{1,0xFEE6},	{1,0xFEE7},
	{1,0xFEE8},	{1,0xFEE9},	{1,0xFEEA},	{1,0xFEEB},
	{1,0xFEEC},	{1,0xFEED},	{1,0xFEEE},	{1,0xFEEF},
	{1,0xFEF0},	{1,0xFEF1},	{1,0xFEF2},	{1,0xFEF3},
	{1,0xFEF4},	{1,0xFEF5},	{1,0xFEF6},	{1,0xFEF7},
	{1,0xFEF8},	{1,0xFEF9},	{1,0xFEFA},	{1,0xFEFB},
	{1,0xFEFC},	{0,0xFEFD},	{0,0xFEFE},	{0,0xFEFF},
{0,0}};

static UDM_UNICODE planeFF[257]={
	{0,0xFF00},	{0,0xFF01},	{0,0xFF02},	{0,0xFF03},
	{0,0xFF04},	{0,0xFF05},	{0,0xFF06},	{0,0xFF07},
	{0,0xFF08},	{0,0xFF09},	{0,0xFF0A},	{0,0xFF0B},
	{0,0xFF0C},	{0,0xFF0D},	{0,0xFF0E},	{0,0xFF0F},
	{2,0xFF10},	{2,0xFF11},	{2,0xFF12},	{2,0xFF13},
	{2,0xFF14},	{2,0xFF15},	{2,0xFF16},	{2,0xFF17},
	{2,0xFF18},	{2,0xFF19},	{0,0xFF1A},	{0,0xFF1B},
	{0,0xFF1C},	{0,0xFF1D},	{0,0xFF1E},	{0,0xFF1F},
	{0,0xFF20},	{1,0xFF41},	{1,0xFF42},	{1,0xFF43},
	{1,0xFF44},	{1,0xFF45},	{1,0xFF46},	{1,0xFF47},
	{1,0xFF48},	{1,0xFF49},	{1,0xFF4A},	{1,0xFF4B},
	{1,0xFF4C},	{1,0xFF4D},	{1,0xFF4E},	{1,0xFF4F},
	{1,0xFF50},	{1,0xFF51},	{1,0xFF52},	{1,0xFF53},
	{1,0xFF54},	{1,0xFF55},	{1,0xFF56},	{1,0xFF57},
	{1,0xFF58},	{1,0xFF59},	{1,0xFF5A},	{0,0xFF3B},
	{0,0xFF3C},	{0,0xFF3D},	{0,0xFF3E},	{0,0xFF3F},
	{0,0xFF40},	{1,0xFF41},	{1,0xFF42},	{1,0xFF43},
	{1,0xFF44},	{1,0xFF45},	{1,0xFF46},	{1,0xFF47},
	{1,0xFF48},	{1,0xFF49},	{1,0xFF4A},	{1,0xFF4B},
	{1,0xFF4C},	{1,0xFF4D},	{1,0xFF4E},	{1,0xFF4F},
	{1,0xFF50},	{1,0xFF51},	{1,0xFF52},	{1,0xFF53},
	{1,0xFF54},	{1,0xFF55},	{1,0xFF56},	{1,0xFF57},
	{1,0xFF58},	{1,0xFF59},	{1,0xFF5A},	{0,0xFF5B},
	{0,0xFF5C},	{0,0xFF5D},	{0,0xFF5E},	{0,0xFF5F},
	{0,0xFF60},	{0,0xFF61},	{0,0xFF62},	{0,0xFF63},
	{0,0xFF64},	{0,0xFF65},	{1,0xFF66},	{1,0xFF67},
	{1,0xFF68},	{1,0xFF69},	{1,0xFF6A},	{1,0xFF6B},
	{1,0xFF6C},	{1,0xFF6D},	{1,0xFF6E},	{1,0xFF6F},
	{1,0xFF70},	{1,0xFF71},	{1,0xFF72},	{1,0xFF73},
	{1,0xFF74},	{1,0xFF75},	{1,0xFF76},	{1,0xFF77},
	{1,0xFF78},	{1,0xFF79},	{1,0xFF7A},	{1,0xFF7B},
	{1,0xFF7C},	{1,0xFF7D},	{1,0xFF7E},	{1,0xFF7F},
	{1,0xFF80},	{1,0xFF81},	{1,0xFF82},	{1,0xFF83},
	{1,0xFF84},	{1,0xFF85},	{1,0xFF86},	{1,0xFF87},
	{1,0xFF88},	{1,0xFF89},	{1,0xFF8A},	{1,0xFF8B},
	{1,0xFF8C},	{1,0xFF8D},	{1,0xFF8E},	{1,0xFF8F},
	{1,0xFF90},	{1,0xFF91},	{1,0xFF92},	{1,0xFF93},
	{1,0xFF94},	{1,0xFF95},	{1,0xFF96},	{1,0xFF97},
	{1,0xFF98},	{1,0xFF99},	{1,0xFF9A},	{1,0xFF9B},
	{1,0xFF9C},	{1,0xFF9D},	{1,0xFF9E},	{1,0xFF9F},
	{1,0xFFA0},	{1,0xFFA1},	{1,0xFFA2},	{1,0xFFA3},
	{1,0xFFA4},	{1,0xFFA5},	{1,0xFFA6},	{1,0xFFA7},
	{1,0xFFA8},	{1,0xFFA9},	{1,0xFFAA},	{1,0xFFAB},
	{1,0xFFAC},	{1,0xFFAD},	{1,0xFFAE},	{1,0xFFAF},
	{1,0xFFB0},	{1,0xFFB1},	{1,0xFFB2},	{1,0xFFB3},
	{1,0xFFB4},	{1,0xFFB5},	{1,0xFFB6},	{1,0xFFB7},
	{1,0xFFB8},	{1,0xFFB9},	{1,0xFFBA},	{1,0xFFBB},
	{1,0xFFBC},	{1,0xFFBD},	{1,0xFFBE},	{0,0xFFBF},
	{0,0xFFC0},	{0,0xFFC1},	{1,0xFFC2},	{1,0xFFC3},
	{1,0xFFC4},	{1,0xFFC5},	{1,0xFFC6},	{1,0xFFC7},
	{0,0xFFC8},	{0,0xFFC9},	{1,0xFFCA},	{1,0xFFCB},
	{1,0xFFCC},	{1,0xFFCD},	{1,0xFFCE},	{1,0xFFCF},
	{0,0xFFD0},	{0,0xFFD1},	{1,0xFFD2},	{1,0xFFD3},
	{1,0xFFD4},	{1,0xFFD5},	{1,0xFFD6},	{1,0xFFD7},
	{0,0xFFD8},	{0,0xFFD9},	{1,0xFFDA},	{1,0xFFDB},
	{1,0xFFDC},	{0,0xFFDD},	{0,0xFFDE},	{0,0xFFDF},
	{0,0xFFE0},	{0,0xFFE1},	{0,0xFFE2},	{0,0xFFE3},
	{0,0xFFE4},	{0,0xFFE5},	{0,0xFFE6},	{0,0xFFE7},
	{0,0xFFE8},	{0,0xFFE9},	{0,0xFFEA},	{0,0xFFEB},
	{0,0xFFEC},	{0,0xFFED},	{0,0xFFEE},	{0,0xFFEF},
	{0,0xFFF0},	{0,0xFFF1},	{0,0xFFF2},	{0,0xFFF3},
	{0,0xFFF4},	{0,0xFFF5},	{0,0xFFF6},	{0,0xFFF7},
	{0,0xFFF8},	{0,0xFFF9},	{0,0xFFFA},	{0,0xFFFB},
	{0,0xFFFC},	{0,0xFFFD},	{0,0xFFFE},	{0,0xFFFF},
{0,0}};

static UDM_UNI_PLANE uni_plane[257]={
	{0,plane00},
	{0,plane01},
	{0,plane02},
	{0,plane03},
	{0,plane04},
	{0,plane05},
	{0,plane06},
	{0,plane07},
	{0,NULL},
	{0,plane09},
	{0,plane0A},
	{0,plane0B},
	{0,plane0C},
	{0,plane0D},
	{0,plane0E},
	{0,plane0F},
	{0,plane10},
	{0,plane11},
	{0,plane12},
	{0,plane13},
	{0,plane14},
	{1,NULL},
	{0,plane16},
	{0,plane17},
	{0,plane18},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,plane1E},
	{0,plane1F},
	{0,plane20},
	{0,plane21},
	{0,NULL},
	{0,NULL},
	{0,plane24},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,plane30},
	{0,plane31},
	{0,NULL},
	{0,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{0,plane4D},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{3,NULL},
	{0,plane9F},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{0,planeA4},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{1,NULL},
	{0,planeD7},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{0,NULL},
	{1,NULL},
	{0,planeFA},
	{0,planeFB},
	{1,NULL},
	{0,planeFD},
	{0,planeFE},
	{0,planeFF},
{0,NULL}};


/* Returns lower case of argument "uni "*/

int UdmUniToLower(int uni){
	int plane;
	int code;

	plane = ((uni) >> 8) % 257;
	code=(uni)&0xFF;
	if(uni_plane[plane].table){
		return(uni_plane[plane].table[code].tolower);
	}
	return(uni);
}


/* Function converts NULL terminated */
/* unistr array to lower case        */

void UdmUniStrToLower(int * unistr){
	int plane;
	for( ;*unistr; unistr++ ){
		plane = ((*unistr) >> 8) % 257;
		if(uni_plane[plane].table)
			(*unistr)=uni_plane[plane].table[(*unistr)&0xFF].tolower;
	}
}

/* Parses null terminated  UNICODE string */
/* Returns tokens without separators      */
int * UdmUniGetToken(int * s, int ** last){
	int ctype0=UDM_UNI_SEPAR,ctype,plane,code;
	int * beg=NULL;

	if(s == NULL && (s=*last) == NULL)
		return NULL;

	/* Skip leading separators */
	for(;*s;s++){
		plane = ((*s) >> 8) % 257;
		code=(*s)&0xFF;
		if(uni_plane[plane].table){
			ctype=uni_plane[plane].table[code].ctype;
		}else{
			ctype=uni_plane[plane].ctype;
		}
		/*fprintf(stderr,"TOK %04X %d\n",*s,ctype);*/
		switch(ctype){
			case UDM_UNI_SEPAR: 
				continue;
			case UDM_UNI_CJK:
				/* Done because of CJK */
				/* is the first letter */
				*last=s+1;
				return(s);
			case UDM_UNI_DIGIT:
			case UDM_UNI_LETTER:
			default:
				/* Store ctype of first character */
				ctype0=ctype;
				beg=s;
				break;
		}
		if(beg)break;
	}

	if(!*s)return NULL;
	*last=NULL;

	/* Skip non-separators */
	for(;(*s);s++){
		plane = ((*s) >> 8) % 257;
		code=(*s)&0xFF;
		if(uni_plane[plane].table){
			ctype=uni_plane[plane].table[code].ctype;
		}else{
			ctype=uni_plane[plane].ctype;
		}
		switch(ctype){
			case UDM_UNI_CJK:
			case UDM_UNI_SEPAR:
				*last=s; /* Done because of separator or CJK */
				return(beg);
			case UDM_UNI_LETTER:
			case UDM_UNI_DIGIT:
			default:
				continue;
		}
	}
	/*fprintf(stderr,"*beg=%04X *s=%04X beg=%d s=%d *last=%d\n",*beg,*s,beg,s,*last);*/

	/* Done because of end-of-line */ 
	*last=s;
	return(beg);
}


/* Parses null terminated  UNICODE string  */
/* Returns all tokens including separators */

int * UdmUniGetSepToken(int * s, int ** last, int *ctype0){
	int ctype,plane,code;
	int * beg;

	if(s == NULL && (s=*last) == NULL)
		return NULL;

	beg=s;

	if(!(*beg))return NULL;

	plane = ((*s) >> 8) % 257;
	code=(*s)&0xFF;
	if(uni_plane[plane].table){
		*ctype0 = uni_plane[plane].table[code].ctype;
	}else{
		*ctype0 = uni_plane[plane].ctype;
	}
	if(*ctype0==UDM_UNI_DIGIT)
		*ctype0=UDM_UNI_LETTER;

	while(*s){
		plane = ((*s) >> 8) % 257;
		code=(*s)&0xFF;
		if(uni_plane[plane].table){
			ctype=uni_plane[plane].table[code].ctype;
		}else{
			ctype=uni_plane[plane].ctype;
		}
		if(ctype==UDM_UNI_DIGIT)
			ctype=UDM_UNI_LETTER;

		if(*ctype0!=ctype)
			break;

		s++;

		if(*ctype0==UDM_UNI_CJK)
			break;
	}

	*last=s;
	return(beg);
}


int UdmUniCType(int uni){
	int ctype,plane,code;

	plane = ((uni) >> 8) % 257;
	code=(uni)&0xFF;

	if(uni_plane[plane].table){
		ctype=uni_plane[plane].table[code].ctype;
	}else{
		ctype=uni_plane[plane].ctype;
	}

	return ctype;
}

